/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ProcessUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012J\"\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000eJ8\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJB\u0010\u001a\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040$H\u0002\u00a8\u0006%"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil$Companion;", "", "()V", "chMod", "", "project", "Lorg/gradle/api/Project;", "mode", "", "fileName", "createRunCommand", "", "baseCommand", "runLocalShell", "", "exec", "Ljava/lang/Process;", "config", "", "execAndCheck", "logFile", "Ljava/io/File;", "execute", "arguments", "", "logOutput", "executeCommand", "command", "workDir", "throwErrorOnFailure", "waitTimeoutSeconds", "", "readLines", "reader", "Ljava/io/BufferedReader;", "lineHandler", "Lkotlin/Function1;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final List<String> createRunCommand(String baseCommand, boolean runLocalShell) {
            return runLocalShell ? (Os.isFamily((String)"windows") ? CollectionsKt.mutableListOf((Object[])new String[]{"cmd", "/c", baseCommand + ".cmd"}) : CollectionsKt.mutableListOf((Object[])new String[]{"./" + baseCommand + ".sh"})) : CollectionsKt.mutableListOf((Object[])new String[]{baseCommand});
        }

        public final void execAndCheck(@NotNull Map<String, ? extends Object> config, @NotNull File logFile) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Intrinsics.checkParameterIsNotNull((Object)logFile, (String)"logFile");
            if (this.exec(config).exitValue() == 1) {
                throw (Throwable)new RuntimeException("Running process was not successfully executed. Check logs [" + logFile + "] for more information.");
            }
        }

        @NotNull
        public final String execute(@NotNull Project project, @NotNull String exec, @NotNull List<String> arguments, boolean logOutput) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)exec, (String)"exec");
            Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
            project.getLogger().lifecycle("About to execute `" + exec + ' ' + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + '`');
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            project.exec((Action)new Action<ExecSpec>(arguments, exec, stdout){
                final /* synthetic */ List $arguments;
                final /* synthetic */ String $exec;
                final /* synthetic */ ByteArrayOutputStream $stdout;

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                    $this$exec.setArgs(this.$arguments);
                    $this$exec.setExecutable(this.$exec);
                    $this$exec.setStandardOutput((OutputStream)this.$stdout);
                }
                {
                    this.$arguments = list;
                    this.$exec = string;
                    this.$stdout = byteArrayOutputStream;
                }
            });
            String output = stdout.toString(StandardCharsets.UTF_8);
            if (logOutput) {
                project.getLogger().lifecycle(output);
            }
            String string = output;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output");
            return string;
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, String string, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.execute(project, string, list, bl);
        }

        @NotNull
        public final Process exec(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            Object object = config.getOrDefault("runLocalShell", (Object)true);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean runLocalShell = (Boolean)object;
            Object object2 = config.get("command");
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            List<String> command = this.createRunCommand((String)object2, runLocalShell);
            if (config.get("params") != null) {
                Object object3 = config.get("params");
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                command.addAll((List)object3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (config.get("environment") != null) {
                Object object4 = config.get("environment");
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                processBuilder.environment().putAll((Map)object4);
            }
            if (config.get("workDir") != null) {
                Object object5 = config.get("workDir");
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                }
                processBuilder.directory((File)object5);
            }
            if (config.get("inheritIO") != null) {
                processBuilder.inheritIO();
            }
            if (config.get("discardIO") != null) {
                processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
            }
            if (config.get("redirectTo") != null) {
                processBuilder.redirectErrorStream(true);
                Object object6 = config.get("redirectTo");
                if (object6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.io.File");
                }
                File redirectTo = (File)object6;
                File file = redirectTo.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"redirectTo.parentFile");
                if (!file.isDirectory()) {
                    redirectTo.getParentFile().mkdirs();
                }
                processBuilder.redirectOutput(ProcessBuilder.Redirect.to(redirectTo));
            }
            Process process = processBuilder.start();
            if (config.get("wait") != null) {
                process.waitFor();
            }
            Process process2 = process;
            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"process");
            return process2;
        }

        public final void chMod(@NotNull Project project, @NotNull String mode, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            project.exec((Action)new Action<ExecSpec>(mode, fileName){
                final /* synthetic */ String $mode;
                final /* synthetic */ String $fileName;

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                    $this$exec.setExecutable("chmod");
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])new String[]{"-R", this.$mode, this.$fileName}));
                }
                {
                    this.$mode = string;
                    this.$fileName = string2;
                }
            });
        }

        @NotNull
        public final String executeCommand(@NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            return this.executeCommand(null, command, workDir, logOutput, throwErrorOnFailure, waitTimeoutSeconds);
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                l = 10L;
            }
            return companion.executeCommand(string, file, bl, bl2, l);
        }

        @NotNull
        public final String executeCommand(@Nullable Project project, @NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Process process;
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            String[] execCommand = new String[]{"sh", "-c", command};
            if (workDir != null) {
                Process process2 = Runtime.getRuntime().exec(execCommand, null, workDir);
                process = process2;
                Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"Runtime.getRuntime().exe\u2026ecCommand, null, workDir)");
            } else {
                Process process3 = Runtime.getRuntime().exec(execCommand);
                process = process3;
                Intrinsics.checkExpressionValueIsNotNull((Object)process3, (String)"Runtime.getRuntime().exec(execCommand)");
            }
            Process process4 = process;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process4.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process4.getErrorStream()));
            String input2 = this.readLines(stdInput, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logOutput, project){
                final /* synthetic */ boolean $logOutput;
                final /* synthetic */ Project $project;

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                    if (this.$logOutput && Intrinsics.areEqual((Object)line, (Object)"") ^ true && this.$project != null) {
                        this.$project.getLogger().lifecycle(line);
                    }
                }
                {
                    this.$logOutput = bl;
                    this.$project = project;
                    super(1);
                }
            }));
            String error2 = this.readLines(stdError, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(logOutput, project){
                final /* synthetic */ boolean $logOutput;
                final /* synthetic */ Project $project;

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                    if (this.$logOutput && Intrinsics.areEqual((Object)line, (Object)"") ^ true && this.$project != null) {
                        this.$project.getLogger().error(line);
                    }
                }
                {
                    this.$logOutput = bl;
                    this.$project = project;
                    super(1);
                }
            }));
            if (process4.waitFor(waitTimeoutSeconds, TimeUnit.SECONDS)) {
                if (throwErrorOnFailure && process4.exitValue() != 0) {
                    throw (Throwable)new RuntimeException("Process '" + command + "' failed with exit value " + process4.exitValue() + ": " + error2);
                }
            } else if (throwErrorOnFailure) {
                throw (Throwable)new RuntimeException("Process '" + command + "' not finished");
            }
            return Intrinsics.areEqual((Object)error2, (Object)"") ? input2 : input2 + System.lineSeparator() + error2;
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, Project project, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                l = 10L;
            }
            return companion.executeCommand(project, string, file, bl, bl2, l);
        }

        private final String readLines(BufferedReader reader, Function1<? super String, Unit> lineHandler) {
            String result = "";
            String line = "";
            while (true) {
                String string = reader.readLine();
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                if (it != null) {
                    line = it;
                }
                if (string == null) break;
                string = line;
                bl = false;
                bl2 = false;
                it = string;
                boolean bl4 = false;
                if (Intrinsics.areEqual((Object)result, (Object)"") ^ true) {
                    result = result + System.lineSeparator();
                }
                result = result + it;
                lineHandler.invoke((Object)line);
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

