/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals.cluster.operator;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.providers.operator.AwsOpenshiftProvider;
import ai.digital.integration.server.common.util.HtmlUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.cluster.operator.OperatorHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0002\u00a8\u0006\u001e"}, d2={"Lai/digital/integration/server/deploy/internals/cluster/operator/AwsOpenshiftHelper;", "Lai/digital/integration/server/deploy/internals/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "exec", "", "command", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getMasterPodName", "position", "", "getOcApiServerToken", "getOperatorImage", "getProvider", "Lai/digital/integration/server/common/domain/providers/operator/AwsOpenshiftProvider;", "getProviderHomeDir", "getStorageClass", "getWorkerPodName", "hasIngress", "", "launchCluster", "", "ocLogout", "shutdownCluster", "updateInfrastructure", "infraInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "waitForPods", "integration-server-gradle-plugin"})
public class AwsOpenshiftHelper
extends OperatorHelper {
    public final void launchCluster() {
        this.updateControllerManager();
        this.updateOperatorApplications();
        this.updateOperatorDeployment();
        this.updateOperatorDeploymentCr();
        this.updateOperatorCrValues();
        InfrastructureInfo infraInfo = this.getKubectlHelper().getCurrentContextInfo(this.getOcApiServerToken());
        this.updateInfrastructure(infraInfo);
        this.applyYamlFiles();
        this.waitForDeployment();
        this.waitForMasterPods();
        this.waitForWorkerPods();
        this.waitForBoot();
    }

    private final void waitForPods() {
    }

    private final String exec(String command) {
        File workDir = new File(this.getProviderHomeDir());
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, command, workDir, false, false, 0L, 28, null);
    }

    private final void ocLogout() {
        try {
            this.exec("oc logout");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String getOcApiServerToken() {
        Object login = this.getProject().property("ocLogin");
        Object password = this.getProject().property("ocPassword");
        Base64.Encoder encoder = Base64.getEncoder();
        String string = "" + login + ':' + password;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String basicAuthToken = encoder.encodeToString(byArray);
        Object object = this.getProvider().getOauthHostName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().oauthHostName.get()");
        String oauthHostName = (String)object;
        this.ocLogout();
        String command1Output = this.exec("curl -vvv -L -k -c cookie -b cookie  -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/request");
        Document doc1 = HtmlUtil.Companion.htmlToDocument(command1Output);
        String string3 = doc1.select("form input[name=\"code\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"doc1.select(\"form input[name=\\\"code\\\"]\").`val`()");
        String code = string3;
        String string4 = doc1.select("form input[name=\"csrf\"]").val();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"doc1.select(\"form input[name=\\\"csrf\\\"]\").`val`()");
        String csrf = string4;
        String command2Output = this.exec("curl -vvv -L -k -c cookie -b cookie -d 'code=" + code + "&csrf=" + csrf + "' -H \"Authorization: Basic " + basicAuthToken + "\" https://" + oauthHostName + "/oauth/token/display");
        Document doc2 = HtmlUtil.Companion.htmlToDocument(command2Output);
        String string5 = doc2.select("code").text();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"doc2.select(\"code\").text()");
        return string5;
    }

    public final void shutdownCluster() {
        this.getProject().getLogger().lifecycle("Undeploy operator");
        this.undeployCis();
        this.getProject().getLogger().lifecycle("Delete all PVCs");
        this.getKubectlHelper().deleteAllPvcs();
        this.ocLogout();
    }

    @Override
    @NotNull
    public String getProviderHomeDir() {
        return this.getOperatorHomeDir() + "/deploy-operator-openshift";
    }

    @Override
    @NotNull
    public AwsOpenshiftProvider getProvider() {
        return this.getProfile().getAwsOpenshift();
    }

    @Override
    @NotNull
    public String getOperatorImage() {
        Object object = this.getProvider().getOperatorImage().value((Object)"xebialabs/deploy-operator:1.2.0-openshift").get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().operatorIm\u2026r:1.2.0-openshift\").get()");
        return (String)object;
    }

    @Override
    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().value((Object)"aws-efs").get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getProvider().storageClass.value(\"aws-efs\").get()");
        return (String)object;
    }

    @Override
    public void updateInfrastructure(@NotNull InfrastructureInfo infraInfo) {
        Intrinsics.checkParameterIsNotNull((Object)infraInfo, (String)"infraInfo");
        File file = new File(this.getProviderHomeDir(), "digitalai-deploy/infrastructure.yaml");
        Pair[] pairArray = new Pair[2];
        String string = infraInfo.getApiServerURL();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].serverUrl", (Object)string);
        String string2 = infraInfo.getToken();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].openshiftToken", (Object)string2);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, false, 4, null);
    }

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), true);
    }

    @Override
    public boolean hasIngress() {
        return false;
    }

    @Override
    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/dai-ocp-xld-digitalai-deploy-ocp-worker-" + position;
    }

    @Override
    @NotNull
    public String getMasterPodName(int position) {
        return "pod/dai-ocp-xld-digitalai-deploy-ocp-master-" + position;
    }

    public AwsOpenshiftHelper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
    }
}

