/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.tests;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.Test;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.TestUtil;
import ai.digital.integration.server.deploy.internals.CliUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "executeScripts", "", "server", "Lai/digital/integration/server/common/domain/Server;", "tests", "", "Lai/digital/integration/server/common/domain/Test;", "launch", "Companion", "integration-server-gradle-plugin"})
public class IntegrationTestsTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "integrationTests";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void executeScripts(Server server, List<? extends Test> tests) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().lifecycle("Executing test scripts ....");
        Iterable $this$forEach$iv = tests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file;
            Test test = (Test)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            project2.getLogger().lifecycle("About to execute test `" + test.getName() + "` ...");
            boolean bl2 = false;
            List filesToExecute = new ArrayList();
            boolean bl3 = false;
            List filesForTeardown = new ArrayList();
            if (test.getBaseDirectory() == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            File dir = file;
            boolean bl6 = false;
            String basedir = dir.getAbsolutePath();
            Iterable $this$forEach$iv2 = test.getSetupScripts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String setupScript = (String)element$iv2;
                boolean bl7 = false;
                String string = basedir;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"basedir");
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(string, '/' + setupScript + '$'));
            }
            String string = basedir;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"basedir");
            filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(string, test.getScriptPattern(), test.getExcludesPattern()));
            $this$forEach$iv2 = test.getTearDownScripts();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String teardownScript = (String)element$iv2;
                boolean bl8 = false;
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(basedir, '/' + teardownScript + '$'));
                filesForTeardown.addAll((Collection)FileUtil.Companion.findFiles(basedir, '/' + teardownScript + '$'));
            }
            try {
                Project project3 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                CliUtil.Companion.executeScripts(project3, (List<? extends File>)filesToExecute, "test", server.getTls(), test);
            }
            catch (Exception ignored) {
                Project project4 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                CliUtil.Companion.executeScripts(project4, (List<? extends File>)filesForTeardown, "teardown", server.getTls(), test);
            }
        }
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        FilesKt.deleteRecursively((File)CliUtil.Companion.getCliLogFolder(project));
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project2);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        this.executeScripts(server, TestUtil.Companion.getExecutableTests(project3));
    }

    public IntegrationTestsTask() {
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

