/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/KubeCtlUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class KubeCtlUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\fJ \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\fJ\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\fH\u0002J \u0010 \u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\fJ\u001e\u0010%\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fJ&\u0010(\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,\u00a8\u0006-"}, d2={"Lai/digital/integration/server/common/util/KubeCtlUtil$Companion;", "", "()V", "apply", "", "project", "Lorg/gradle/api/Project;", "file", "Ljava/io/File;", "deleteAllPvcs", "deleteCurrentContext", "getClusterCertificateAuthorityData", "", "clusterName", "getClusterServer", "getContextCluster", "contextName", "getContextUser", "getCurrentContext", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "token", "getIngresHost", "ingressName", "getNameAndGrep", "command", "grepFor", "getServiceExternalIp", "serviceName", "getUserClientCertificateData", "userName", "getUserClientKeyData", "getWithPath", "jsonpath", "hasStorageClass", "", "storageClass", "setDefaultStorageClass", "oldDefaultStorageClass", "newDefaultStorageClass", "wait", "resource", "condition", "timeoutSeconds", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final void apply(@NotNull Project project, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl apply -f " + file.getAbsolutePath(), null, false, false, 0L, 60, null);
        }

        public final boolean wait(@NotNull Project project, @NotNull String resource, @NotNull String condition, int timeoutSeconds) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull((Object)condition, (String)"condition");
            project.getLogger().lifecycle("Waiting for resource " + resource + " to be " + condition);
            long expectedEndTime = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
            while (expectedEndTime > System.currentTimeMillis()) {
                String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl wait --for condition=" + condition + " --timeout=" + timeoutSeconds + "s " + resource, null, false, false, 0L, 44, null);
                if (StringsKt.contains$default((CharSequence)result, (CharSequence)"condition met", (boolean)false, (int)2, null)) {
                    return true;
                }
                Thread.sleep(1000L);
            }
            return false;
        }

        public final void setDefaultStorageClass(@NotNull Project project, @NotNull String oldDefaultStorageClass, @NotNull String newDefaultStorageClass) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)oldDefaultStorageClass, (String)"oldDefaultStorageClass");
            Intrinsics.checkParameterIsNotNull((Object)newDefaultStorageClass, (String)"newDefaultStorageClass");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, " kubectl patch storageclass " + newDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"true\"}}}'", null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, " kubectl patch storageclass " + oldDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"false\"}}}'", null, false, false, 0L, 60, null);
        }

        public final boolean hasStorageClass(@NotNull Project project, @NotNull String storageClass) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)storageClass, (String)"storageClass");
            String result = this.getNameAndGrep(project, "storageclass", storageClass);
            return StringsKt.contains$default((CharSequence)result, (CharSequence)storageClass, (boolean)false, (int)2, null);
        }

        @NotNull
        public final InfrastructureInfo getCurrentContextInfo(@NotNull Project project, @Nullable String token) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String context = this.getCurrentContext(project);
            String cluster = this.getContextCluster(project, context);
            String user = this.getContextUser(project, context);
            return new InfrastructureInfo(cluster, user, this.getClusterServer(project, cluster), token, this.getClusterCertificateAuthorityData(project, cluster), this.getUserClientCertificateData(project, user), this.getUserClientKeyData(project, user));
        }

        public static /* synthetic */ InfrastructureInfo getCurrentContextInfo$default(Companion companion, Project project, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.getCurrentContextInfo(project, string);
        }

        public final void deleteCurrentContext(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String context = this.getCurrentContext(project);
            String cluster = this.getContextCluster(project, context);
            String user = this.getContextUser(project, context);
            project.getLogger().info("Delete current context {} with related cluster {} and user {} information", new Object[]{context, cluster, user});
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config delete-context " + context, null, false, false, 0L, 44, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config delete-user " + user, null, false, false, 0L, 44, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config delete-cluster " + cluster, null, false, false, 0L, 44, null);
        }

        public final void deleteAllPvcs(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl delete pvc --all", null, false, false, 0L, 44, null);
        }

        @NotNull
        public final String getIngresHost(@NotNull Project project, @NotNull String ingressName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)ingressName, (String)"ingressName");
            return this.getWithPath(project, "ing " + ingressName, "{.items[*].spec.rules[*].host}");
        }

        @NotNull
        public final String getServiceExternalIp(@NotNull Project project, @NotNull String serviceName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
            return this.getWithPath(project, "service " + serviceName, "{.status.loadBalancer.ingress[*].ip}");
        }

        private final String getCurrentContext(Project project) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config current-context", null, false, false, 0L, 52, null);
        }

        private final String getContextCluster(Project project, String contextName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.contexts[?(@.name == \"" + contextName + "\")].context.cluster}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getContextUser(Project project, String contextName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.contexts[?(@.name == \"" + contextName + "\")].context.user}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getClusterServer(Project project, String clusterName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.clusters[?(@.name == \"" + clusterName + "\")].cluster.server}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getClusterCertificateAuthorityData(Project project, String clusterName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority-data}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getUserClientKeyData(Project project, String userName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.users[?(@.name == \"" + userName + "\")].user.client-key-data}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getUserClientCertificateData(Project project, String userName) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl config view -o jsonpath='{.users[?(@.name == \"" + userName + "\")].user.client-certificate-data}' --raw", null, false, false, 0L, 52, null);
        }

        private final String getNameAndGrep(Project project, String command, String grepFor) {
            long l = 0L;
            boolean bl = false;
            boolean bl2 = false;
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl get " + command + " -o name | grep " + grepFor, null, bl, bl2, l, 36, null);
        }

        private final String getWithPath(Project project, String command, String jsonpath) {
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl get " + command + " -o \"jsonpath=" + jsonpath + '\"', null, false, false, 0L, 60, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

