/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.kube.scanning;

import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.KubeScanningUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "createECRImageTag", "", "ecrKubeBenchImage", "", "createEcrRepoAndLogin", "kubeBenchBuildAndPushImage", "launch", "pushImageToECR", "updateKubeBenchImage", "Companion", "integration-server-gradle-plugin"})
public class KubeAwsScannerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "kubeAwsScanner";
    @NotNull
    public static final String reportFile = "aws-eks";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void kubeBenchBuildAndPushImage(String ecrKubeBenchImage) {
        this.createEcrRepoAndLogin();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KubeScanningUtil.Companion.buildKubeBench(project);
        this.createECRImageTag(ecrKubeBenchImage);
        this.pushImageToECR(ecrKubeBenchImage);
    }

    private final void createEcrRepoAndLogin() {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder().append("aws ecr --region ");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string = stringBuilder.append(KubeScanningUtil.Companion.getRegion(project2)).append(" create-repository --repository-name k8s/kube-bench --image-tag-mutability MUTABLE").toString();
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
        Project project4 = this.getProject();
        StringBuilder stringBuilder2 = new StringBuilder().append("aws ecr --region ");
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        StringBuilder stringBuilder3 = stringBuilder2.append(KubeScanningUtil.Companion.getRegion(project5)).append(" get-login-password --region ");
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        StringBuilder stringBuilder4 = stringBuilder3.append(KubeScanningUtil.Companion.getRegion(project6)).append(" | docker login --username AWS --password-stdin ");
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        String string2 = stringBuilder4.append(KubeScanningUtil.Companion.getAWSAccountId(project7)).toString();
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project4, string2, null, KubeScanningUtil.Companion.getKubeScanner(project8).getLogOutput(), false, 0L, 52, null);
    }

    private final void createECRImageTag(String ecrKubeBenchImage) {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder().append("docker tag k8s/kube-bench:");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string = stringBuilder.append(KubeScanningUtil.Companion.getKubeScanner(project2).getKubeBenchTagVersion()).append(' ').append(ecrKubeBenchImage).toString();
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
    }

    private final void pushImageToECR(String ecrKubeBenchImage) {
        Project project = this.getProject();
        String string = "docker push " + ecrKubeBenchImage;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project2).getLogOutput(), false, 0L, 52, null);
    }

    private final void updateKubeBenchImage(String ecrKubeBenchImage) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = new File(KubeScanningUtil.Companion.getKubeBenchDir(project), "job-eks.yaml");
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, file, "spec.template.spec.containers[0].command", false, 4, null);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
        }
        List existingCommand = TypeIntrinsics.asMutableList((Object)object);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"spec.template.spec.containers[0].image", (Object)ecrKubeBenchImage);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        pairArray[1] = TuplesKt.to((Object)"spec.template.spec.containers[0].command", KubeScanningUtil.Companion.getCommand(project2, existingCommand));
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile(file, pairs, false);
    }

    @TaskAction
    public final void launch() {
        StringBuilder stringBuilder = new StringBuilder();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        StringBuilder stringBuilder2 = stringBuilder.append(KubeScanningUtil.Companion.getAWSAccountId(project)).append("/k8s/kube-bench:");
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String ecrKubeBenchImage = stringBuilder2.append(KubeScanningUtil.Companion.getKubeScanner(project2).getKubeBenchTagVersion()).toString();
        this.kubeBenchBuildAndPushImage(ecrKubeBenchImage);
        this.updateKubeBenchImage(ecrKubeBenchImage);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        KubeCtlHelper kubeCtlHelper = KubeScanningUtil.Companion.getKubectlHelper(project3);
        StringBuilder stringBuilder3 = new StringBuilder();
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        kubeCtlHelper.applyFile(new File(stringBuilder3.append(KubeScanningUtil.Companion.getKubeBenchDir(project4)).append("/job-eks.yaml").toString()));
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        KubeScanningUtil.Companion.generateReport(project5, "aws-eks.log");
    }

    public KubeAwsScannerTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"checkingOutKubeBench"});
        this.finalizedBy(new Object[]{"KubeAwsScannerFinalizer"});
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerTask$Companion;", "", "()V", "NAME", "", "reportFile", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

