/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/YamlFileUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class YamlFileUtil {
    private static final ObjectMapper mapper;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bH\u0002J5\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J:\u0010\u0011\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u0012\u0004\u0012\u00020\t0\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0013\u001a\u00020\tJ,\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00192\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bJ*\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00192\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\tJ&\u0010!\u001a\u0004\u0018\u00010\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020$J\u0016\u0010%\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lai/digital/integration/server/common/util/YamlFileUtil$Companion;", "", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "addPair", "", "initial", "", "", "newPairs", "calcKeyChain", "", "objectMap", "tokens", "", "(Ljava/util/Map;Ljava/util/List;)[Ljava/lang/String;", "getKeyParentAndLastToken", "Lkotlin/Pair;", "key", "mingleValues", "source", "Ljava/net/URL;", "pairs", "destinationFile", "Ljava/io/File;", "overlayFile", "sourceAndDestinationFle", "sourceFle", "overlayResource", "resource", "readFileKey", "file", "readKey", "readTree", "Lcom/fasterxml/jackson/core/TreeNode;", "Ljava/io/InputStream;", "writeFileValue", "value", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final String[] calcKeyChain(Map<String, Object> objectMap, List<String> tokens) {
            String[] stringArray;
            if (objectMap.get(tokens.get(0) + "." + tokens.get(1)) != null) {
                Object[] keyChain = new String[]{tokens.get(0) + "." + tokens.get(1)};
                stringArray = (String[])ArraysKt.plus((Object[])keyChain, (Collection)CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)tokens, (int)2), (int)1));
            } else {
                Object[] keyChain = new String[]{tokens.get(0)};
                stringArray = (String[])ArraysKt.plus((Object[])keyChain, (Collection)CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)tokens, (int)1), (int)1));
            }
            return stringArray;
        }

        @NotNull
        public final Pair<Map<String, Object>, String> getKeyParentAndLastToken(@NotNull Map<String, Object> objectMap, @NotNull String key) {
            Intrinsics.checkParameterIsNotNull(objectMap, (String)"objectMap");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            List tokens = StringsKt.split$default((CharSequence)key, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            String[] keyChain = this.calcKeyChain(objectMap, tokens);
            Map current = objectMap;
            String[] $this$forEach$iv = keyChain;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String keyItem = element$iv = stringArray[i];
                boolean bl = false;
                Object value = current.get(keyItem);
                if (value == null) {
                    current.put((String)keyItem, new LinkedHashMap());
                }
                Object object = current.get(keyItem);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                }
                current = TypeIntrinsics.asMutableMap((Object)object);
            }
            return new Pair(current, CollectionsKt.last((List)tokens));
        }

        private final Object readKey(Map<String, Object> objectMap, String key) {
            Pair<Map<String, Object>, String> pair = this.getKeyParentAndLastToken(objectMap, key);
            return ((Map)pair.getFirst()).get(pair.getSecond());
        }

        private final void addPair(Map<String, Object> initial, Map<String, Object> newPairs) {
            Map<String, Object> $this$forEach$iv = newPairs;
            boolean $i$f$forEach = false;
            Map<String, Object> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> pair = element$iv = iterator.next();
                boolean bl2 = false;
                Pair<Map<String, Object>, String> p = Companion.getKeyParentAndLastToken(initial, pair.getKey());
                ((Map)p.getFirst()).put(p.getSecond(), pair.getValue());
            }
        }

        private final void mingleValues(URL source, Map<String, Object> pairs, File destinationFile) {
            Object object = mapper.readValue(source, Map.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            Map aggregatedValue = TypeIntrinsics.asMutableMap((Object)object);
            this.addPair(aggregatedValue, pairs);
            mapper.writeValue(destinationFile, (Object)aggregatedValue);
        }

        private final void mingleValues(Map<String, Object> pairs, File destinationFile) {
            LinkedHashMap aggregatedValue = new LinkedHashMap();
            this.addPair(aggregatedValue, pairs);
            mapper.writeValue(destinationFile, aggregatedValue);
        }

        public final void overlayFile(@NotNull File sourceFle, @NotNull Map<String, Object> pairs, @NotNull File destinationFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFle, (String)"sourceFle");
            Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
            Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
            if (!sourceFle.exists()) {
                sourceFle.createNewFile();
                this.mingleValues(pairs, destinationFile);
            } else {
                URL uRL = sourceFle.toURI().toURL();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"sourceFle.toURI().toURL()");
                this.mingleValues(uRL, pairs, destinationFile);
            }
        }

        public final void overlayFile(@NotNull File sourceAndDestinationFle, @NotNull Map<String, Object> pairs) {
            Intrinsics.checkParameterIsNotNull((Object)sourceAndDestinationFle, (String)"sourceAndDestinationFle");
            Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
            if (!sourceAndDestinationFle.exists()) {
                sourceAndDestinationFle.createNewFile();
                this.mingleValues(pairs, sourceAndDestinationFle);
            } else {
                URL uRL = sourceAndDestinationFle.toURI().toURL();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"sourceAndDestinationFle.toURI().toURL()");
                this.mingleValues(uRL, pairs, sourceAndDestinationFle);
            }
        }

        public final void overlayResource(@NotNull URL resource, @NotNull Map<String, Object> pairs, @NotNull File destinationFile) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            Intrinsics.checkParameterIsNotNull(pairs, (String)"pairs");
            Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
            this.mingleValues(resource, pairs, destinationFile);
        }

        @Nullable
        public final Object readFileKey(@NotNull File file, @NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Object object = mapper.readValue(file, Map.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            return this.readKey(TypeIntrinsics.asMutableMap((Object)object), key);
        }

        @NotNull
        public final TreeNode readTree(@NotNull InputStream resource) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            JsonNode jsonNode = mapper.readTree(resource);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonNode, (String)"mapper.readTree(resource)");
            return (TreeNode)jsonNode;
        }

        public final void writeFileValue(@NotNull File sourceFle, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFle, (String)"sourceFle");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (!sourceFle.exists()) {
                new File(sourceFle.getParent()).mkdirs();
                sourceFle.createNewFile();
            }
            mapper.writeValue(sourceFle, value);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

