/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.deploy.internals.DeployDockerClusterHelper;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/EntryPointUrlUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class EntryPointUrlUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lai/digital/integration/server/deploy/internals/EntryPointUrlUtil$Companion;", "", "()V", "composeUrl", "", "project", "Lorg/gradle/api/Project;", "path", "getContextRoot", "getHttpHost", "getHttpPort", "getPropertyValue", "key", "clusterValue", "getUrl", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final String getPropertyValue(Project project, String key, String clusterValue) {
            DeployDockerClusterHelper helper = new DeployDockerClusterHelper(project);
            if (helper.isClusterEnabled()) {
                return clusterValue;
            }
            return DeployServerUtil.Companion.readDeployitConfProperty(project, key);
        }

        @NotNull
        public final String getHttpPort(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            DeployDockerClusterHelper helper = new DeployDockerClusterHelper(project);
            return this.getPropertyValue(project, "http.port", helper.getClusterPublicPort());
        }

        @NotNull
        public final String getContextRoot(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getPropertyValue(project, "http.context.root", "");
        }

        @NotNull
        public final String getHttpHost() {
            return "localhost";
        }

        @NotNull
        public final String getUrl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String contextRoot = this.getContextRoot(project);
            String host = this.getHttpHost();
            String port = this.getHttpPort(project);
            String protocol = DeployServerUtil.Companion.isTls(project) ? "https" : "http";
            return protocol + "://" + host + ':' + port + contextRoot;
        }

        @NotNull
        public final String composeUrl(@NotNull Project project, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String url = this.getUrl(project);
            String separator = "/";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                separator = "";
                if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                    url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
                }
            }
            return url + separator + path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

