/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.domain.Cluster;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.DockerUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployDockerClusterHelper;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionCompletedEvent;
import net.jodah.failsafe.event.ExecutionScheduledEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedSupplier;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0006J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020\u0006H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0011H\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u0006H\u0002J\b\u0010.\u001a\u00020\u0006H\u0002J\u0010\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0006H\u0002J\b\u00101\u001a\u00020\rH\u0002J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\rJ\b\u00105\u001a\u000203H\u0002J \u00106\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0002J\u0010\u00108\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u001dH\u0002J\b\u00109\u001a\u00020\rH\u0002J\b\u0010:\u001a\u00020\rH\u0002J\u0006\u0010;\u001a\u00020\rJ\b\u0010<\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lai/digital/integration/server/deploy/internals/DeployDockerClusterHelper;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "lbIp", "", "getProject", "()Lorg/gradle/api/Project;", "workerToIp", "", "", "allowToCleanMountedFiles", "", "serviceName", "dockerFilePath", "folders", "", "allowToRemoveClusterMountedVolumes", "configureRabbitMq", "createClusterMetadata", "createNetwork", "createServerFolders", "createWorkerFolders", "getCluster", "Lai/digital/integration/server/common/domain/Cluster;", "getClusterPublicPort", "getClusterVersion", "getDockerXldHAFile", "Ljava/io/File;", "getDockerXldHAWithWorkersPath", "getEnvironmentVariables", "", "template", "getLbIp", "getMasterIp", "order", "getNumberOfServers", "getResolvedXldHaDockerComposeFile", "Ljava/nio/file/Path;", "getResolvedXldHaWithWorkersDockerComposeFile", "getServerVersionedImage", "getServers", "Lai/digital/integration/server/common/domain/Server;", "getTemplate", "path", "getWorkerVersionedImage", "giveAllPermissionsForMountedVolume", "folderPath", "inspectIps", "isClusterEnabled", "", "launchCluster", "networkExists", "openDebugPort", "range", "overrideWorkerCommand", "runServers", "runWorkers", "shutdownCluster", "waitForBoot", "Companion", "integration-server-gradle-plugin"})
public class DeployDockerClusterHelper {
    private final Map<Integer, String> workerToIp;
    private String lbIp;
    @NotNull
    private final Project project;
    private static final String clusterMetadataPath = "deploy/cluster/cluster-metadata.properties";
    private static final String dockerXldHAPath = "deploy/cluster/docker-compose-xld-ha.yaml";
    private static final String dockerXldHAWithWorkersPath = "deploy/cluster/docker-compose-xld-ha-slim-workers.yaml";
    private static final String rabbitMqEnabledPluginsPath = "deploy/cluster/rabbitmq/enabled_plugins";
    private static final int privateDebugPort = 4005;
    private static final List<String> serverMountedVolumes;
    private static final List<String> workerMountedVolumes;
    @NotNull
    public static final Companion Companion;

    private final Cluster getCluster() {
        Object object = DeployExtensionUtil.Companion.getExtension(this.project).getCluster().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DeployExtensionUtil.getE\u2026on(project).cluster.get()");
        return (Cluster)object;
    }

    private final String getClusterVersion() {
        Server server = (Server)CollectionsKt.first(this.getServers());
        return server.getVersion();
    }

    public final boolean isClusterEnabled() {
        return this.getCluster().getEnable();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Server> getServers() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(this.project).getServers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Server server = (Server)element$iv$iv;
            boolean bl = false;
            if (!(!server.getPreviousInstallation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final int getNumberOfServers() {
        return this.getServers().size();
    }

    private final String getServerVersionedImage() {
        Server server = (Server)CollectionsKt.first(this.getServers());
        CharSequence charSequence = server.getDockerImage();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw (Throwable)new RuntimeException("Incorrect configuration. Server should have `dockerImage` field defined.");
        }
        return server.getDockerImage() + ':' + this.getClusterVersion();
    }

    private final String getWorkerVersionedImage() {
        Worker worker = (Worker)CollectionsKt.first(WorkerUtil.Companion.getWorkers(this.project));
        CharSequence charSequence = worker.getDockerImage();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw (Throwable)new RuntimeException("Incorrect configuration. Worker should have `dockerImage` field defined.");
        }
        return worker.getDockerImage() + ':' + this.getClusterVersion();
    }

    private final void configureRabbitMq() {
        block0: {
            InputStream dockerComposeStream2 = ((Object)((Object)configureRabbitMq.dockerComposeStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(rabbitMqEnabledPluginsPath);
            Path resultComposeFilePath = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, "rabbitmq/enabled_plugins");
            resultComposeFilePath.getParent().toFile().mkdirs();
            InputStream inputStream = dockerComposeStream2;
            if (inputStream == null) break block0;
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            FileUtil.Companion.copyFile(it, resultComposeFilePath);
        }
    }

    @NotNull
    public final String getClusterPublicPort() {
        return String.valueOf(this.getCluster().getPublicPort());
    }

    private final void createClusterMetadata() {
        Path path = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, clusterMetadataPath);
        Properties props = new Properties();
        ((Map)props).put("cluster.port", this.getClusterPublicPort());
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        PropertiesUtil.Companion.writePropertiesFile(file, props);
    }

    private final Path getResolvedXldHaDockerComposeFile() {
        File template = this.getTemplate(dockerXldHAPath);
        String serviceName = "xl-deploy-master";
        String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)template, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_MASTER_IMAGE}}", (String)this.getServerVersionedImage(), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)IntegrationServerUtil.Companion.getDist(this.project), (boolean)false, (int)4, null), (String)"{{DEPLOY_NETWORK_NAME}}", (String)"xld-network", (boolean)false, (int)4, null), (String)"{{PUBLIC_PORT}}", (String)this.getClusterPublicPort(), (boolean)false, (int)4, null), (String)"{{HA_PORT}}", (String)String.valueOf(HTTPUtil.Companion.findFreePort()), (boolean)false, (int)4, null), (String)"{{DB_PORT}}", (String)String.valueOf(HTTPUtil.Companion.findFreePort()), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)template, (String)configuredTemplate, null, (int)2, null);
        this.openDebugPort(template, serviceName, "4000-4049");
        Path path = template.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"template.toPath()");
        return path;
    }

    private final Path getResolvedXldHaWithWorkersDockerComposeFile() {
        File template = this.getTemplate(dockerXldHAWithWorkersPath);
        String serviceName = "xl-deploy-worker";
        String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)template, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_WORKER_IMAGE}}", (String)this.getWorkerVersionedImage(), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)IntegrationServerUtil.Companion.getDist(this.project), (boolean)false, (int)4, null), (String)"{{DEPLOY_NETWORK_NAME}}", (String)"xld-network", (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)template, (String)configuredTemplate, null, (int)2, null);
        this.overrideWorkerCommand(template);
        this.openDebugPort(template, serviceName, "4050-4100");
        Path path = template.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"template.toPath()");
        return path;
    }

    private final void openDebugPort(File template, String serviceName, String range) {
        var $fun$getServiceOpts$1 = new Function0<String>(this){
            final /* synthetic */ DeployDockerClusterHelper this$0;

            @NotNull
            public final String invoke() {
                String suspend = DeployDockerClusterHelper.access$getCluster(this.this$0).getDebugSuspend() ? "y" : "n";
                return "DEPLOYIT_SERVER_OPTS=-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=*:4005";
            }
            {
                this.this$0 = deployDockerClusterHelper;
                super(0);
            }
        };
        if (this.getCluster().getEnableDebug()) {
            List<String> variables = this.getEnvironmentVariables(template, serviceName);
            variables.add((String)$fun$getServiceOpts$1.invoke());
            CollectionsKt.sort(variables);
            Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)("services." + serviceName + ".environment"), variables), TuplesKt.to((Object)("services." + serviceName + ".ports"), (Object)CollectionsKt.listOf((Object)(range + ":4005")))});
            YamlFileUtil.Companion.overlayFile(template, pairs);
        }
    }

    private final List<String> getEnvironmentVariables(File template, String serviceName) {
        Object object = YamlFileUtil.Companion.readFileKey(template, "services." + serviceName + ".environment");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
        }
        return TypeIntrinsics.asMutableList((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    private final void overrideWorkerCommand(File template) {
        List commandArgs = CollectionsKt.mutableListOf((Object[])new String[]{"-api", "http://" + this.lbIp + ":5000/"});
        int n = 1;
        int n2 = this.getNumberOfServers();
        if (n <= n2) {
            while (true) {
                void orderNum;
                commandArgs.add("-master");
                commandArgs.add(this.workerToIp.get((int)orderNum) + ":8180");
                if (orderNum == n2) break;
                ++orderNum;
            }
        }
        Map pairs = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"services.xl-deploy-worker.command", (Object)commandArgs)});
        YamlFileUtil.Companion.overlayFile(template, pairs);
    }

    private final File getTemplate(String path) {
        Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(this.project, path);
        File file = resultComposeFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resultComposeFilePath.toFile()");
        return file;
    }

    private final boolean networkExists() {
        CharSequence charSequence = DockerUtil.Companion.execute$default(DockerUtil.Companion, this.project, CollectionsKt.listOf((Object[])new String[]{"network", "ls", "--filter", "name=^xld-network$", "--format=\"{{ .Name }}\""}), false, 4, null);
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)charSequence);
    }

    private final void createNetwork() {
        if (!this.networkExists()) {
            this.project.exec((Action)createNetwork.1.INSTANCE);
        }
    }

    private final void runServers() {
        this.configureRabbitMq();
        this.createServerFolders();
        int num = this.getNumberOfServers();
        Object[] objectArray = new String[6];
        objectArray[0] = "-f";
        String string = this.getResolvedXldHaDockerComposeFile().toFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResolvedXldHaDockerCo\u2026ile().toFile().toString()");
        objectArray[1] = string;
        objectArray[2] = "up";
        objectArray[3] = "-d";
        objectArray[4] = "--scale";
        objectArray[5] = "xl-deploy-master=" + num;
        List args = CollectionsKt.listOf((Object[])objectArray);
        this.project.getLogger().lifecycle("Running " + num + " server(s) with a command: `docker-compose " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + '`');
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
    }

    private final void runWorkers() {
        this.createWorkerFolders();
        String num = String.valueOf(WorkerUtil.Companion.getNumberOfWorkers(this.project));
        Object[] objectArray = new String[6];
        objectArray[0] = "-f";
        String string = this.getResolvedXldHaWithWorkersDockerComposeFile().toFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResolvedXldHaWithWork\u2026ile().toFile().toString()");
        objectArray[1] = string;
        objectArray[2] = "up";
        objectArray[3] = "-d";
        objectArray[4] = "--scale";
        objectArray[5] = "xl-deploy-worker=" + num;
        List args = CollectionsKt.listOf((Object[])objectArray);
        this.project.getLogger().lifecycle("Running " + num + " workers(s) with a command: `docker-compose " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + '`');
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void inspectIps() {
        int n = 1;
        int n2 = this.getNumberOfServers();
        if (n <= n2) {
            while (true) {
                void orderNum;
                this.workerToIp.put((int)orderNum, this.getMasterIp((int)orderNum));
                if (orderNum == n2) break;
                ++orderNum;
            }
        }
        this.lbIp = this.getLbIp();
    }

    private final String getLbIp() {
        int maxAttempts = 5;
        Function0<String> $fun$inspectLbIp$1 = new Function0<String>(this){
            final /* synthetic */ DeployDockerClusterHelper this$0;

            @NotNull
            public final String invoke() {
                return DockerUtil.Companion.inspect(this.this$0.getProject(), "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", "xl-deploy-lb");
            }
            {
                this.this$0 = deployDockerClusterHelper;
                super(0);
            }
        };
        RetryPolicy retryPolicy2 = ((RetryPolicy)new RetryPolicy().withMaxAttempts(maxAttempts).withBackoff(1L, 30L, ChronoUnit.SECONDS).handleResult((Object)"")).onRetriesExceeded((CheckedConsumer)new CheckedConsumer<ExecutionCompletedEvent<String>>(this, maxAttempts){
            final /* synthetic */ DeployDockerClusterHelper this$0;
            final /* synthetic */ int $maxAttempts;

            public final void accept(ExecutionCompletedEvent<String> it) {
                this.this$0.getProject().getLogger().warn("Failed to inspect Load Balancer IP. Max retries " + this.$maxAttempts + " exceeded.");
            }
            {
                this.this$0 = deployDockerClusterHelper;
                this.$maxAttempts = n;
            }
        }).onRetryScheduled((CheckedConsumer)new CheckedConsumer<ExecutionScheduledEvent<String>>(this){
            final /* synthetic */ DeployDockerClusterHelper this$0;

            public final void accept(ExecutionScheduledEvent<String> it) {
                this.this$0.getProject().getLogger().lifecycle("Retry scheduled {}.");
            }
            {
                this.this$0 = deployDockerClusterHelper;
            }
        });
        return (String)Failsafe.with((Policy)((Policy)retryPolicy2), (Policy[])new RetryPolicy[0]).get((CheckedSupplier)new CheckedSupplier<String>($fun$inspectLbIp$1){
            final /* synthetic */ getLbIp.1 $inspectLbIp$1;

            public final String get() {
                return this.$inspectLbIp$1.invoke();
            }
            {
                this.$inspectLbIp$1 = var1_1;
            }
        });
    }

    private final String getMasterIp(int order) {
        return DockerUtil.Companion.inspect(this.project, "{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}", "cluster_xl-deploy-master_" + order);
    }

    public final void shutdownCluster() {
        Object[] objectArray = new String[5];
        objectArray[0] = "-f";
        String string = this.getResolvedXldHaWithWorkersDockerComposeFile().toFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResolvedXldHaWithWork\u2026ile().toFile().toString()");
        objectArray[1] = string;
        objectArray[2] = "-f";
        String string2 = this.getResolvedXldHaDockerComposeFile().toFile().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getResolvedXldHaDockerCo\u2026ile().toFile().toString()");
        objectArray[3] = string2;
        objectArray[4] = "down";
        List args = CollectionsKt.listOf((Object[])objectArray);
        DockerComposeUtil.Companion.execute$default(DockerComposeUtil.Companion, this.project, args, false, 4, null);
    }

    private final void waitForBoot() {
        String url = EntryPointUrlUtil.Companion.composeUrl(this.project, "/deployit/metadata/type");
        Server server = DeployServerUtil.Companion.getServer(this.project);
        WaitForBootUtil.Companion.byPort(this.project, "Deploy", url, null, server.getPingRetrySleepTime(), server.getPingTotalTries());
    }

    private final void createServerFolders() {
        Iterable $this$forEach$iv = serverMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-server/" + folderName;
            File folder = new File(folderPath);
            folder.mkdirs();
            this.giveAllPermissionsForMountedVolume(folderPath);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been created.");
        }
    }

    private final void createWorkerFolders() {
        Iterable $this$forEach$iv = workerMountedVolumes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folderName = (String)element$iv;
            boolean bl = false;
            String folderPath = IntegrationServerUtil.Companion.getDist(this.project) + "/xl-deploy-worker/" + folderName;
            File folder = new File(folderPath);
            folder.mkdirs();
            this.giveAllPermissionsForMountedVolume(folderPath);
            this.project.getLogger().lifecycle("Folder " + folderPath + " has been created.");
        }
    }

    private final void giveAllPermissionsForMountedVolume(String folderPath) {
        ProcessUtil.Companion.chMod(this.project, "766", folderPath);
    }

    private final void allowToCleanMountedFiles(String serviceName, String dockerFilePath, List<String> folders) {
        Iterable $this$forEach$iv = folders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String folder = (String)element$iv;
            boolean bl = false;
            ArrayList args = CollectionsKt.arrayListOf((Object[])new String[]{"-f", dockerFilePath, "exec", "-T", serviceName, "chmod", "766", "-R", folder});
            DockerComposeUtil.Companion.execute(this.project, args, true);
        }
    }

    private final File getDockerXldHAFile() {
        File file = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, dockerXldHAPath).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"IntegrationServerUtil.ge\u2026dockerXldHAPath).toFile()");
        return file;
    }

    private final File getDockerXldHAWithWorkersPath() {
        File file = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, dockerXldHAWithWorkersPath).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"IntegrationServerUtil.ge\u2026th)\n            .toFile()");
        return file;
    }

    private final void allowToRemoveClusterMountedVolumes() {
        String string;
        String it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string2 = this.getDockerXldHAFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDockerXldHAFile().path");
        Iterable iterable = serverMountedVolumes;
        String string3 = string2;
        String string4 = "xl-deploy-master";
        DeployDockerClusterHelper deployDockerClusterHelper = this;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string5 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = "/opt/xebialabs/xl-deploy-server/" + it;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        deployDockerClusterHelper.allowToCleanMountedFiles(string4, string3, (List<String>)collection);
        String string6 = this.getDockerXldHAWithWorkersPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getDockerXldHAWithWorkersPath().path");
        $this$map$iv = workerMountedVolumes;
        string3 = string6;
        string4 = "xl-deploy-worker";
        deployDockerClusterHelper = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = "/opt/xebialabs/deploy-task-engine/" + it;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        deployDockerClusterHelper.allowToCleanMountedFiles(string4, string3, (List<String>)collection);
    }

    public final void launchCluster() {
        this.createNetwork();
        this.runServers();
        this.inspectIps();
        this.runWorkers();
        this.createClusterMetadata();
        this.waitForBoot();
        this.allowToRemoveClusterMountedVolumes();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DeployDockerClusterHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl = false;
        this.workerToIp = new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        serverMountedVolumes = CollectionsKt.listOf((Object[])new String[]{"centralConfiguration", "conf", "plugins"});
        workerMountedVolumes = CollectionsKt.listOf((Object[])new String[]{"conf", "plugins"});
    }

    public static final /* synthetic */ Cluster access$getCluster(DeployDockerClusterHelper $this) {
        return $this.getCluster();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/internals/DeployDockerClusterHelper$Companion;", "", "()V", "clusterMetadataPath", "", "dockerXldHAPath", "dockerXldHAWithWorkersPath", "privateDebugPort", "", "rabbitMqEnabledPluginsPath", "serverMountedVolumes", "", "workerMountedVolumes", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

