/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.tasks.satellite.ShutdownSatelliteTask;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "copyStopSatelliteScript", "", "satellite", "Lai/digital/integration/server/deploy/domain/Satellite;", "stop", "stopSatellite", "Companion", "integration-server-gradle-plugin"})
public class ShutdownSatelliteTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "shutdownSatellite";
    @NotNull
    public static final String STOP_SATELLITE_SCRIPT = "stopSatellite.sh";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void copyStopSatelliteScript(Satellite satellite) {
        block0: {
            InputStream from2 = ((Object)((Object)copyStopSatelliteScript.from.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream("satellite/bin/stopSatellite.sh");
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Path intoDir = Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project, satellite), new String[0]).resolve(STOP_SATELLITE_SCRIPT);
            InputStream inputStream = from2;
            if (inputStream == null) break block0;
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream source = inputStream2;
            boolean bl3 = false;
            Path path = intoDir;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"intoDir");
            FileUtil.Companion.copyFile(source, path);
        }
    }

    private final void stopSatellite(Satellite satellite) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ProcessUtil.Companion.chMod(project, "766", ((Object)Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project2, satellite), new String[0]).resolve(STOP_SATELLITE_SCRIPT).toAbsolutePath()).toString());
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"stopSatellite");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        pairArray[1] = TuplesKt.to((Object)"workDir", (Object)new File(SatelliteUtil.Companion.getSatelliteWorkingDir(project3, satellite)));
        ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        project4.getLogger().lifecycle("Satellite server '" + satellite.getName() + "' successfully shutdown.");
    }

    @TaskAction
    public final void stop() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            project2.getLogger().lifecycle("Shutting down satellite " + satellite.getName());
            this.copyStopSatelliteScript(satellite);
            this.stopSatellite(satellite);
        }
    }

    public ShutdownSatelliteTask() {
        this.setGroup("Integration Server");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/ShutdownSatelliteTask$Companion;", "", "()V", "NAME", "", "STOP_SATELLITE_SCRIPT", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

