/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ProcessUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012J\"\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u000e\u00a8\u0006\u001b"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil$Companion;", "", "()V", "chMod", "", "project", "Lorg/gradle/api/Project;", "mode", "", "fileName", "createRunCommand", "", "baseCommand", "runLocalShell", "", "exec", "Ljava/lang/Process;", "config", "", "execAndCheck", "logFile", "Ljava/io/File;", "execute", "executable", "args", "", "logOutput", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final List<String> createRunCommand(String baseCommand, boolean runLocalShell) {
            return runLocalShell ? (Os.isFamily((String)"windows") ? CollectionsKt.mutableListOf((Object[])new String[]{"cmd", "/c", baseCommand + ".cmd"}) : CollectionsKt.mutableListOf((Object[])new String[]{"./" + baseCommand + ".sh"})) : CollectionsKt.mutableListOf((Object[])new String[]{baseCommand});
        }

        public final void execAndCheck(@NotNull Map<String, ? extends Object> config, @NotNull File logFile) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
            if (this.exec(config).exitValue() == 1) {
                throw (Throwable)new RuntimeException("Running process was not successfully executed. Check logs [" + logFile + "] for more information.");
            }
        }

        @NotNull
        public final String execute(@NotNull Project project, @NotNull String executable, @NotNull List<String> args, boolean logOutput) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            project.exec((Action)new Action<ExecSpec>(args, executable, stdout){
                final /* synthetic */ List $args;
                final /* synthetic */ String $executable;
                final /* synthetic */ ByteArrayOutputStream $stdout;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                    execSpec.setArgs(this.$args);
                    it.setExecutable(this.$executable);
                    it.setStandardOutput((OutputStream)this.$stdout);
                }
                {
                    this.$args = list;
                    this.$executable = string;
                    this.$stdout = byteArrayOutputStream;
                }
            });
            String output = stdout.toString(StandardCharsets.UTF_8);
            if (logOutput) {
                project.getLogger().lifecycle(output);
            }
            String string = output;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output");
            return string;
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, String string, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.execute(project, string, list, bl);
        }

        @NotNull
        public final Process exec(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Object object = config.getOrDefault("runLocalShell", (Object)true);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            boolean runLocalShell = (Boolean)object;
            Object object2 = config.get("command");
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            List<String> command = this.createRunCommand((String)object2, runLocalShell);
            if (config.get("params") != null) {
                Object object3 = config.get("params");
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                command.addAll((List)object3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (config.get("environment") != null) {
                Object object4 = config.get("environment");
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                processBuilder.environment().putAll((Map)object4);
            }
            Object object5 = config.get("workDir");
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.io.File");
            }
            processBuilder.directory((File)object5);
            if (config.get("inheritIO") != null) {
                processBuilder.inheritIO();
            }
            if (config.get("discardIO") != null) {
                processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
            }
            if (config.get("redirectTo") != null) {
                processBuilder.redirectErrorStream(true);
                Object object6 = config.get("redirectTo");
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.io.File");
                }
                File redirectTo = (File)object6;
                File file = redirectTo.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"redirectTo.parentFile");
                if (!file.isDirectory()) {
                    redirectTo.getParentFile().mkdirs();
                }
                processBuilder.redirectOutput(ProcessBuilder.Redirect.to(redirectTo));
            }
            Process process = processBuilder.start();
            if (config.get("wait") != null) {
                process.waitFor();
            }
            Process process2 = process;
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            return process2;
        }

        public final void chMod(@NotNull Project project, @NotNull String mode, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            project.exec((Action)new Action<ExecSpec>(mode, fileName){
                final /* synthetic */ String $mode;
                final /* synthetic */ String $fileName;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                    execSpec.setExecutable("chmod");
                    it.setArgs(CollectionsKt.listOf((Object[])new String[]{"-R", this.$mode, this.$fileName}));
                }
                {
                    this.$mode = string;
                    this.$fileName = string2;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

