/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.database;

import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import com.palantir.gradle.docker.DockerComposeUp;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/common/tasks/database/DatabaseStartTask;", "Lcom/palantir/gradle/docker/DockerComposeUp;", "()V", "getDescription", "", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public abstract class DatabaseStartTask
extends DockerComposeUp {
    @NotNull
    public static final String NAME = "databaseStart";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder().append("Starts database instance using `docker-compose` and ");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return stringBuilder.append(DbUtil.Companion.dockerComposeFileName(project)).append(" file.").toString();
    }

    @InputFiles
    @NotNull
    public File getDockerComposeFile() {
        CodeSource src;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DbUtil.Companion.assertNotDerby(project, "Docker compose tasks do not support Derby database.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Path resultComposeFilePath = DbUtil.Companion.getResolveDbFilePath(project2);
        ProtectionDomain protectionDomain = DatabaseStartTask.class.getProtectionDomain();
        Intrinsics.checkNotNullExpressionValue((Object)protectionDomain, (String)"DatabaseStartTask::class.java.protectionDomain");
        CodeSource codeSource = src = protectionDomain.getCodeSource();
        if (codeSource != null) {
            ZipEntry entry;
            CodeSource codeSource2 = codeSource;
            boolean bl = false;
            boolean bl2 = false;
            CodeSource codeSource3 = codeSource2;
            boolean bl3 = false;
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            String dbName = DbUtil.Companion.databaseName(project3);
            File file = resultComposeFilePath.getParent().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resultComposeFilePath.parent.toFile()");
            new File(file.getPath(), dbName + "-docker").mkdirs();
            URL jar = codeSource3.getLocation();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String dockerFileName;
                String name = entry.getName();
                String folderName = "database-compose/" + dbName + "-docker/";
                String string = name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (!StringsKt.startsWith$default((String)string, (String)folderName, (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)name, (Object)folderName) ^ true)) continue;
                String string2 = name;
                int n = StringsKt.indexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                InputStream inputStream = zip;
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                FileUtil.Companion.copyFile(inputStream, IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project4, dockerFileName));
            }
        }
        File file = this.getProject().file((Object)resultComposeFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(resultComposeFilePath)");
        return file;
    }

    @TaskAction
    public void run() {
        super.run();
    }

    public DatabaseStartTask() {
        this.setGroup("Integration Server");
        this.mustRunAfter(new Object[]{"applicationConfigurationOverride"});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/tasks/database/DatabaseStartTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

