/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.domain.AkkaSecured;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/WorkerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class WorkerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001f\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lai/digital/integration/server/deploy/internals/WorkerUtil$Companion;", "", "()V", "composeProgramParams", "", "", "project", "Lorg/gradle/api/Project;", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "hostName", "port", "useWorkerCommand", "", "enrichWorker", "getDebugPort", "", "(Lorg/gradle/api/Project;Lai/digital/integration/server/deploy/domain/Worker;)Ljava/lang/Integer;", "getNumberOfWorkers", "getRuntimeDirectory", "getWorkerVersion", "getWorkerWorkingDir", "getWorkers", "hasNonSlimWorkers", "hasRuntimeDirectory", "hasSlimWorkers", "hasWorkers", "isDistDownloadRequired", "isExternalRuntimeWorker", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final boolean hasWorkers(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return DeployExtensionUtil.Companion.getExtension(project).getWorkers().size() > 0;
        }

        public final boolean hasSlimWorkers(@NotNull Project project) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable $this$any$iv = this.getWorkers(project);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Worker worker = (Worker)element$iv;
                        boolean bl2 = false;
                        if (!worker.getSlimDistribution()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean hasNonSlimWorkers(@NotNull Project project) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable $this$any$iv = this.getWorkers(project);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Worker worker = (Worker)element$iv;
                        boolean bl2 = false;
                        if (!(!worker.getSlimDistribution())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Worker> getWorkers(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$map$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getWorkers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void worker;
                Worker worker2 = (Worker)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Worker worker3 = Companion.enrichWorker(project, (Worker)worker);
                collection.add(worker3);
            }
            return (List)destination$iv$iv;
        }

        public final int getNumberOfWorkers(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getWorkers(project).size();
        }

        private final Worker enrichWorker(Project project, Worker worker) {
            worker.setDebugPort(this.getDebugPort(project, worker));
            worker.setVersion(this.getWorkerVersion(project, worker));
            return worker;
        }

        @NotNull
        public final String getWorkerWorkingDir(@NotNull Project project, @NotNull Worker worker) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            if (this.getRuntimeDirectory(project, worker) == null) {
                String targetDir = IntegrationServerUtil.Companion.getDist(project);
                String prefix = worker.getSlimDistribution() ? "deploy-task-engine" : "xl-deploy-worker";
                string = ((Object)Paths.get(targetDir, worker.getName(), prefix + '-' + worker.getVersion()).toAbsolutePath()).toString();
            } else {
                String string2 = project.getProjectDir().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.projectDir.toString()");
                String target = string2;
                string = ((Object)Paths.get(target, this.getRuntimeDirectory(project, worker)).toAbsolutePath()).toString();
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isExternalRuntimeWorker(@NotNull Project project, @NotNull Worker worker) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            if (this.getRuntimeDirectory(project, worker) == null) return true;
            CharSequence charSequence = this.getRuntimeDirectory(project, worker);
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null) return false;
            if (charSequence.length() == 0) {
                return false;
            }
            boolean bl3 = false;
            if (bl3) return false;
            if (!(Intrinsics.areEqual((Object)this.getWorkerWorkingDir(project, worker), (Object)DeployServerUtil.Companion.getServerWorkingDir(project)) ^ true)) return false;
            return true;
        }

        public final boolean isDistDownloadRequired(@NotNull Project project, @NotNull Worker worker) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            return this.getRuntimeDirectory(project, worker) == null;
        }

        @NotNull
        public final List<String> composeProgramParams(@NotNull Project project, @NotNull Worker worker, @NotNull String hostName, @NotNull String port, boolean useWorkerCommand) {
            List params2;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
                Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
                Intrinsics.checkNotNullParameter((Object)port, (String)"port");
                params2 = CollectionsKt.mutableListOf((Object[])new String[]{"-master", "127.0.0.1:" + port, "-api", DeployServerUtil.Companion.getUrl(project), "-hostname", hostName, "-name", worker.getName(), "-port", worker.getPort()});
                if (!worker.getSlimDistribution() && useWorkerCommand) {
                    params2.add(0, "worker");
                }
                if (!DeployServerUtil.Companion.isAkkaSecured(project)) break block4;
                AkkaSecured akkaSecured = TlsUtil.Companion.getAkkaSecured(project, DeployServerUtil.Companion.getServerWorkingDir(project));
                if (akkaSecured != null) {
                    AkkaSecured akkaSecured2 = akkaSecured;
                    boolean bl = false;
                    boolean bl2 = false;
                    AkkaSecured secured = akkaSecured2;
                    boolean bl3 = false;
                    AkkaSecured.KeyMeta keyMeta = secured.getKeys().get("akka_ssl_worker_" + worker.getName());
                    if (keyMeta != null) {
                        AkkaSecured.KeyMeta keyMeta2 = keyMeta;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        AkkaSecured.KeyMeta key = keyMeta2;
                        boolean bl6 = false;
                        params2.addAll(CollectionsKt.listOf((Object[])new String[]{"-keyStore", key.keyStoreFile().getAbsolutePath(), "-keyStorePassword", key.getKeyStorePassword(), "-trustStore", secured.trustStoreFile().getAbsolutePath(), "-trustStorePassword", secured.getTruststorePassword()}));
                        if (Intrinsics.areEqual((Object)"jks", (Object)"pkcs12") ^ true) {
                            params2.addAll(CollectionsKt.listOf((Object[])new String[]{"-keyPassword", key.getKeyPassword()}));
                        }
                    }
                }
            }
            return params2;
        }

        public final boolean hasRuntimeDirectory(@NotNull Project project, @NotNull Worker worker) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
            return this.getRuntimeDirectory(project, worker) != null;
        }

        private final String getRuntimeDirectory(Project project, Worker worker) {
            return worker.getRuntimeDirectory() != null ? worker.getRuntimeDirectory() : DeployServerUtil.Companion.getServer(project).getRuntimeDirectory();
        }

        private final String getWorkerVersion(Project project, Worker worker) {
            CharSequence charSequence = worker.getVersion();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return worker.getVersion();
            }
            if (project.hasProperty("deployTaskEngineVersion")) {
                return String.valueOf(project.property("deployTaskEngineVersion"));
            }
            charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return String.valueOf(DeployServerUtil.Companion.getServer(project).getVersion());
            }
            if (!this.hasRuntimeDirectory(project, worker)) {
                project.getLogger().error("Worker Version is not specified");
                int n = 1;
                bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            return null;
        }

        private final Integer getDebugPort(Project project, Worker worker) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "workerDebugPort", worker.getDebugPort()) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

