/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.util;

import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.util.DeployExtensionUtil;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/util/SatelliteUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class SatelliteUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001f\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/deploy/util/SatelliteUtil$Companion;", "", "()V", "enrichSatellite", "Lai/digital/integration/server/deploy/domain/Satellite;", "project", "Lorg/gradle/api/Project;", "satellite", "getBinDir", "Ljava/io/File;", "getDebugPort", "", "(Lorg/gradle/api/Project;Lai/digital/integration/server/deploy/domain/Satellite;)Ljava/lang/Integer;", "getSatelliteConf", "getSatelliteLog", "getSatelliteLogDir", "getSatelliteVersion", "", "getSatelliteWorkingDir", "getSatellites", "", "hasSatellites", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        public final boolean hasSatellites(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection collection = this.getSatellites(project);
            boolean bl = false;
            return !collection.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Satellite> getSatellites(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$map$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getSatellites();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void satellite;
                Satellite satellite2 = (Satellite)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Satellite satellite3 = Companion.enrichSatellite(project, (Satellite)satellite);
                collection.add(satellite3);
            }
            return (List)destination$iv$iv;
        }

        private final Satellite enrichSatellite(Project project, Satellite satellite) {
            satellite.setDebugPort(this.getDebugPort(project, satellite));
            satellite.setVersion(this.getSatelliteVersion(project, satellite));
            return satellite;
        }

        @NotNull
        public final String getSatelliteWorkingDir(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            String targetDir = IntegrationServerUtil.Companion.getDist(project);
            return ((Object)Paths.get(targetDir, satellite.getName(), "xl-satellite-server-" + satellite.getVersion()).toAbsolutePath()).toString();
        }

        @NotNull
        public final File getBinDir(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File file = Paths.get(this.getSatelliteWorkingDir(project, satellite), "bin").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(getSatelliteWo\u2026tellite), \"bin\").toFile()");
            return file;
        }

        @NotNull
        public final File getSatelliteLogDir(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File file = project.file((Object)(this.getSatelliteWorkingDir(project, satellite) + "/log"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${getSatel\u2026roject, satellite)}/log\")");
            return file;
        }

        @NotNull
        public final File getSatelliteLog(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File file = project.file((Object)(this.getSatelliteLogDir(project, satellite) + "/xl-satellite.log"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${getSatel\u2026lite)}/xl-satellite.log\")");
            return file;
        }

        @NotNull
        public final File getSatelliteConf(@NotNull Project project, @NotNull Satellite satellite) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)satellite, (String)"satellite");
            File file = project.file((Object)(this.getSatelliteWorkingDir(project, satellite) + "/conf/satellite.conf"));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${getSatel\u2026e)}/conf/satellite.conf\")");
            return file;
        }

        private final String getSatelliteVersion(Project project, Satellite satellite) {
            String string;
            if (project.hasProperty("xlSatelliteVersion")) {
                string = String.valueOf(project.property("xlSatelliteVersion"));
            } else {
                CharSequence charSequence = satellite.getVersion();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    string = satellite.getVersion();
                } else {
                    charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
                    bl = false;
                    bl2 = false;
                    if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                        string = DeployServerUtil.Companion.getServer(project).getVersion();
                    } else {
                        project.getLogger().error("Satellite Version is not specified");
                        int n = 1;
                        bl = false;
                        System.exit(n);
                        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
            }
            return string;
        }

        private final Integer getDebugPort(Project project, Satellite satellite) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "satelliteDebugPort", satellite.getDebugPort()) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

