/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.docker;

import ai.digital.integration.server.deploy.util.DeployServerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToCleanMountedFiles", "", "getDockerComposeFile", "Ljava/io/File;", "run", "Companion", "integration-server-gradle-plugin"})
public class DockerBasedStopDeployTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "dockerBasedStopDeploy";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @InputFiles
    @NotNull
    public final File getDockerComposeFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = DeployServerUtil.Companion.getResolvedDockerFile(project).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"DeployServerUtil.getReso\u2026kerFile(project).toFile()");
        return file;
    }

    private final void allowToCleanMountedFiles() {
        this.getProject().exec((Action)new Action<ExecSpec>(this){
            final /* synthetic */ DockerBasedStopDeployTask this$0;

            public final void execute(ExecSpec it) {
                ExecSpec execSpec = it;
                Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                execSpec.setExecutable("docker-compose");
                Object[] objectArray = new String[9];
                objectArray[0] = "-f";
                objectArray[1] = this.this$0.getDockerComposeFile().getPath();
                objectArray[2] = "exec";
                objectArray[3] = "-T";
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                objectArray[4] = DeployServerUtil.Companion.getDockerServiceName(project);
                objectArray[5] = "chmod";
                objectArray[6] = "777";
                objectArray[7] = "-R";
                objectArray[8] = "/opt/xebialabs/xl-deploy-server";
                it.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
                it.setErrorOutput((OutputStream)new ByteArrayOutputStream());
                it.setIgnoreExitValue(true);
            }
            {
                this.this$0 = dockerBasedStopDeployTask;
            }
        });
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Logger logger = project.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Stopping Deploy Server from a docker image ");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        logger.lifecycle(stringBuilder.append(DeployServerUtil.Companion.getDockerImageVersion(project2)).toString());
        this.allowToCleanMountedFiles();
        this.getProject().exec((Action)new Action<ExecSpec>(this){
            final /* synthetic */ DockerBasedStopDeployTask this$0;

            public final void execute(ExecSpec it) {
                ExecSpec execSpec = it;
                Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                execSpec.setExecutable("docker-compose");
                it.setArgs((List)CollectionsKt.arrayListOf((Object[])new String[]{"-f", this.this$0.getDockerComposeFile().getPath(), "down", "-v"}));
            }
            {
                this.this$0 = dockerBasedStopDeployTask;
            }
        });
    }

    public DockerBasedStopDeployTask() {
        this.dependsOn(new Object[]{"prepareDeploy"});
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

