/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.util;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/util/DeployServerInitializeUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployServerInitializeUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/util/DeployServerInitializeUtil$Companion;", "", "()V", "createConfFile", "", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "createFolders", "prepare", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final void createFolders(Project project) {
            project.getLogger().lifecycle("Preparing server destination folders.");
            String[] $this$forEach$iv = new String[]{"centralConfiguration", "conf", "hotfix/plugins", "hotfix/lib", "plugins"};
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String folderName = element$iv = stringArray[i];
                boolean bl = false;
                String folderPath = DeployServerUtil.Companion.getServerWorkingDir(project) + '/' + folderName;
                File folder = new File(folderPath);
                folder.mkdirs();
                project.getLogger().lifecycle("Folder " + folderPath + " has created.");
            }
        }

        private final void createConfFile(Project project, Server server) {
            project.getLogger().lifecycle("Creating deployit.conf file");
            File file = project.file((Object)(DeployServerUtil.Companion.getServerWorkingDir(project) + "/conf/deployit.conf"));
            file.createNewFile();
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            FilesKt.writeText$default((File)file2, (String)("http.port=" + server.getHttpPort() + '\n'), null, (int)2, null);
            FilesKt.appendText$default((File)file, (String)"http.bind.address=0.0.0.0\n", null, (int)2, null);
            FilesKt.appendText$default((File)file, (String)("http.context.root=" + server.getContextRoot() + '\n'), null, (int)2, null);
            FilesKt.appendText$default((File)file, (String)"threads.min=3\n", null, (int)2, null);
            FilesKt.appendText$default((File)file, (String)"threads.max=24\n", null, (int)2, null);
            FilesKt.appendText$default((File)file, (String)"xl.spring.cloud.enabled=true\n", null, (int)2, null);
        }

        public final void prepare(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project);
            project.getLogger().lifecycle("Preparing serve " + server.getName() + " before launching it.");
            this.createFolders(project);
            this.createConfFile(project, server);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

