/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.Tls;
import ai.digital.integration.server.common.util.CentralConfigurationUtil;
import ai.digital.integration.server.common.util.JavaUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.SslUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.tasks.worker.StartWorkersTask;
import ai.digital.integration.server.deploy.util.DeployExtensionUtil;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.deploy.util.EnvironmentUtil;
import ai.digital.integration.server.deploy.util.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/StartWorkersTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getBinDir", "Ljava/io/File;", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "getLogDir", "launch", "", "logFileName", "", "workerName", "startWorker", "Ljava/lang/Process;", "startWorkerFromClasspath", "waitForBoot", "process", "Companion", "integration-server-gradle-plugin"})
public abstract class StartWorkersTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "startWorkers";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final File getBinDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project, worker), "bin").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(WorkerUtil.get\u2026 worker), \"bin\").toFile()");
        return file;
    }

    private final File getLogDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project, worker), "log").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(WorkerUtil.get\u2026 worker), \"log\").toFile()");
        return file;
    }

    private final String logFileName(String workerName) {
        return "deploy-worker-" + workerName;
    }

    private final Process startWorker(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Launching worker " + worker + ".name");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String hostName = CentralConfigurationUtil.Companion.readServerKey(project2, "deploy.server.hostname");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        String port = CentralConfigurationUtil.Companion.readServerKey(project3, "deploy.server.port");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        List<String> params2 = WorkerUtil.Companion.composeProgramParams(project4, worker, hostName, port, true);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project5, "JDK_JAVA_OPTIONS", worker.getDebugSuspend(), worker.getDebugPort(), this.logFileName(worker.getName()));
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        project6.getLogger().info("Starting worker with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"params", params2);
        pairArray[2] = TuplesKt.to((Object)"environment", environment);
        pairArray[3] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir(worker));
        CharSequence charSequence = worker.getStdoutFileName();
        boolean bl = false;
        boolean bl2 = false;
        pairArray[4] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
        charSequence = worker.getStdoutFileName();
        bl = false;
        bl2 = false;
        pairArray[5] = TuplesKt.to((Object)"redirectTo", (Object)(!(charSequence == null || charSequence.length() == 0) ? new File(this.getLogDir(worker) + '/' + worker.getStdoutFileName()) : null));
        return ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
    }

    private final Process startWorkerFromClasspath(Worker worker) {
        boolean bl;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        FileCollection fileCollection = project.getConfigurations().getByName("integrationTestServer").filter((Spec)startWorkerFromClasspath.classpath.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.configurations.g\u2026ndsWith(\"-sources.jar\") }");
        String classpath2 = fileCollection.getAsPath();
        this.getLogger().debug("XL Deploy Worker classpath: \n" + classpath2);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String hostName = CentralConfigurationUtil.Companion.readServerKey(project2, "deploy.server.hostname");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        String port = CentralConfigurationUtil.Companion.readServerKey(project3, "deploy.server.port");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        List<String> programArgs = WorkerUtil.Companion.composeProgramParams(project4, worker, hostName, port, false);
        List jvmArgs = CollectionsKt.toMutableList((Collection)ArraysKt.toList((Object[])worker.getJvmArgs()));
        jvmArgs.add("-DLOGFILE=" + this.logFileName(worker.getName()));
        Integer n = worker.getDebugPort();
        if (n != null) {
            Integer n2 = n;
            boolean bl2 = false;
            bl = false;
            int dPort = ((Number)n2).intValue();
            boolean bl3 = false;
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
            jvmArgs.addAll((Collection)JavaUtil.Companion.debugJvmArg(project5, dPort, worker.getDebugSuspend()));
        }
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
        if (DeployServerUtil.Companion.isTls(project6)) {
            Object object;
            Project project7 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
            Project project8 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
            Tls tls = SslUtil.Companion.getTls(project7, DeployServerUtil.Companion.getServerWorkingDir(project8));
            Object[] objectArray = new String[2];
            objectArray[0] = "-Djavax.net.ssl.trustStore=" + ((object = tls) != null && (object = ((Tls)object).trustStoreFile()) != null ? ((File)object).getAbsolutePath() : null);
            Tls tls2 = tls;
            objectArray[1] = "-Djavax.net.ssl.trustStorePassword=" + (tls2 != null ? tls2.getTruststorePassword() : null);
            CollectionsKt.addAll((Collection)jvmArgs, (Object[])objectArray);
        }
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"classpath", (Object)classpath2);
        CharSequence charSequence = worker.getStdoutFileName();
        bl = false;
        boolean bl4 = false;
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? 1 : 0));
        pairArray[2] = TuplesKt.to((Object)"jvmArgs", (Object)jvmArgs);
        pairArray[3] = TuplesKt.to((Object)"mainClass", (Object)"com.xebialabs.deployit.TaskExecutionEngineBootstrapper");
        pairArray[4] = TuplesKt.to((Object)"programArgs", programArgs);
        charSequence = worker.getStdoutFileName();
        bl = false;
        bl4 = false;
        pairArray[5] = TuplesKt.to((Object)"redirectTo", (Object)(!(charSequence == null || charSequence.length() == 0) ? new File(this.getLogDir(worker) + '/' + worker.getStdoutFileName()) : null));
        Project project9 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"project");
        pairArray[6] = TuplesKt.to((Object)"workDir", (Object)new File(WorkerUtil.Companion.getWorkerWorkingDir(project9, worker)));
        Map config = MapsKt.mutableMapOf((Pair[])pairArray);
        if (this.getProject().hasProperty("integrationServerJVMPath")) {
            Project project10 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project10, (String)"project");
            config.putAll(JavaUtil.Companion.jvmPath(project10, String.valueOf(this.getProject().property("integrationServerJVMPath"))));
        }
        Project project11 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project11, (String)"project");
        Logger logger = project11.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Starting Worker ").append(worker.getName()).append(" for project ");
        Project project12 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project12, (String)"project");
        logger.lifecycle(stringBuilder.append(project12.getName()).append(" on a port: ").append(worker.getPort()).toString());
        return JavaUtil.Companion.execJava(config);
    }

    private final void waitForBoot(Worker worker, Process process) {
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File workerLog = project.file((Object)stringBuilder.append(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker)).append("/log/").append(this.logFileName(worker.getName())).append(".log").toString());
        String containsLine = "Registered successfully with Actor[akka://task-sys@127.0.0.1";
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project3);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        String string = "worker " + worker.getName();
        File file = workerLog;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"workerLog");
        WaitForBootUtil.Companion.byLog(project4, string, file, containsLine, process, server.getPingRetrySleepTime(), server.getPingTotalTries());
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        NamedDomainObjectContainer<Worker> workers = DeployExtensionUtil.Companion.getExtension(project).getWorkers();
        Iterable $this$forEach$iv = (Iterable)workers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker = (Worker)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            Worker worker2 = worker;
            Intrinsics.checkNotNullExpressionValue((Object)worker2, (String)"worker");
            Process process = WorkerUtil.Companion.hasRuntimeDirectory(project2, worker2) ? this.startWorkerFromClasspath(worker) : this.startWorker(worker);
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            project3.getLogger().lifecycle("Worker '" + worker.getName() + "' successfully started on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            this.waitForBoot(worker, process);
        }
    }

    public StartWorkersTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasNonSlimWorkers(project)) {
            this.dependsOn(new Object[]{"copyIntegrationServer"});
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasSlimWorkers(project2)) {
            this.dependsOn(new Object[]{"downloadAndExtractWorkerServer"});
            this.dependsOn(new Object[]{"syncServerPluginsWithWorker"});
        }
        this.dependsOn(new Object[]{"setWorkerLogbackLevels"});
        this.dependsOn(new Object[]{"startMq"});
        this.dependsOn(new Object[]{"workerOverlays"});
        this.dependsOn(new Object[]{"yamlPatch"});
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/StartWorkersTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

