/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.DbParameters;
import ai.digital.integration.server.common.domain.MqParameters;
import ai.digital.integration.server.common.domain.api.Container;
import ai.digital.integration.server.common.domain.api.DriverDependencyAware;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.MqUtil;
import ai.digital.integration.server.deploy.DeployIntegrationServerExtension;
import ai.digital.integration.server.deploy.util.DeployExtensionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/OverlaysUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class OverlaysUtil {
    @NotNull
    public static final String HOTFIX_LIB_KEY = "hotfix/lib";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJN\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013J8\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/common/util/OverlaysUtil$Companion;", "", "()V", "HOTFIX_LIB_KEY", "", "addDatabaseDependency", "", "project", "Lorg/gradle/api/Project;", "container", "Lai/digital/integration/server/common/domain/api/Container;", "addMqDependency", "defineOverlay", "currentTask", "Lorg/gradle/api/Task;", "workingDir", "prefix", "overlay", "", "", "dependedTasks", "overlayDependency", "version", "libOverlays", "", "dependency", "Lai/digital/integration/server/common/domain/api/DriverDependencyAware;", "shouldUnzip", "", "file", "Ljava/io/File;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private final boolean shouldUnzip(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null);
        }

        public final void defineOverlay(@NotNull Project project, @NotNull Task currentTask, @NotNull String workingDir, @NotNull String prefix, @NotNull Map.Entry<String, ? extends List<? extends Object>> overlay, @NotNull List<String> dependedTasks) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)currentTask, (String)"currentTask");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter(overlay, (String)"overlay");
            Intrinsics.checkNotNullParameter(dependedTasks, (String)"dependedTasks");
            String configurationName = prefix + StringsKt.replace$default((String)StringsKt.capitalize((String)overlay.getKey()), (String)"/", (String)"", (boolean)false, (int)4, null);
            ScriptHandler scriptHandler = project.getBuildscript();
            Intrinsics.checkNotNullExpressionValue((Object)scriptHandler, (String)"project.buildscript");
            Configuration config = (Configuration)scriptHandler.getConfigurations().create(configurationName);
            Iterable $this$forEach$iv = overlay.getValue();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object dependencyNotation = element$iv = iterator.next();
                boolean bl = false;
                ScriptHandler scriptHandler2 = project.getBuildscript();
                Intrinsics.checkNotNullExpressionValue((Object)scriptHandler2, (String)"project.buildscript");
                scriptHandler2.getDependencies().add(configurationName, dependencyNotation);
            }
            TaskProvider copyTask2 = project.getTasks().register("copy" + StringsKt.capitalize((String)configurationName), Copy.class, (Action)new Action<Copy>(config, project, workingDir, overlay){
                final /* synthetic */ Configuration $config;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $workingDir;
                final /* synthetic */ Map.Entry $overlay;

                public final void execute(Copy copy) {
                    Configuration configuration = this.$config;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"config");
                    Set set = configuration.getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"config.files");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        File file = (File)element$iv;
                        boolean bl = false;
                        Object[] objectArray = new Object[1];
                        File file2 = file;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        objectArray[0] = ai.digital.integration.server.common.util.OverlaysUtil$Companion.access$shouldUnzip(OverlaysUtil.Companion, file2) ? this.$project.zipTree((Object)file) : file;
                        copy.from(objectArray);
                    }
                    copy.into((Object)(this.$workingDir + '/' + (String)this.$overlay.getKey()));
                }
                {
                    this.$config = configuration;
                    this.$project = project;
                    this.$workingDir = string;
                    this.$overlay = entry;
                }
            });
            Collection collection = dependedTasks;
            boolean bl = false;
            if (!collection.isEmpty()) {
                TaskContainer taskContainer = project.getTasks();
                TaskProvider taskProvider = copyTask2;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"copyTask");
                taskContainer.getByName(taskProvider.getName()).dependsOn(new Object[]{dependedTasks});
            }
            currentTask.dependsOn(new Object[]{copyTask2});
        }

        private final void overlayDependency(Project project, String version, Container container, List<Object> libOverlays, DriverDependencyAware dependency) {
            if (version != null) {
                CharSequence charSequence = version;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    if (container.getRuntimeDirectory() != null) {
                        Configuration configuration;
                        Configuration configuration2 = configuration = project.getConfigurations().getByName("integrationTestServer");
                        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
                        configuration2.getDependencies().add((Object)project.getDependencies().create((Object)(dependency.getDriverDependency() + ':' + version)));
                    }
                    libOverlays.add(dependency.getDriverDependency() + ':' + version);
                    container.getOverlays().put(OverlaysUtil.HOTFIX_LIB_KEY, libOverlays);
                }
            }
        }

        public final void addDatabaseDependency(@NotNull Project project, @NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            String dbname = DbUtil.Companion.databaseName(project);
            DbParameters dbDependencies = DbUtil.Companion.detectDbDependencies(dbname);
            boolean bl = false;
            List<Object> libOverlay = container.getOverlays().getOrDefault(OverlaysUtil.HOTFIX_LIB_KEY, new ArrayList());
            String version = (String)((Map)DbUtil.Companion.getDatabase(project).getDriverVersions().get()).get(dbname);
            this.overlayDependency(project, version, container, libOverlay, dbDependencies);
        }

        public final void addMqDependency(@NotNull Project project, @NotNull Container container) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            String mqName = MqUtil.Companion.mqName(project);
            MqParameters mqDependency = MqUtil.Companion.detectMqDependency(mqName);
            DeployIntegrationServerExtension ext = DeployExtensionUtil.Companion.getExtension(project);
            boolean bl = false;
            List<Object> libOverlay = container.getOverlays().getOrDefault(OverlaysUtil.HOTFIX_LIB_KEY, new ArrayList());
            String version = ext.getMqDriverVersions().get(mqName);
            this.overlayDependency(project, version, container, libOverlay, mqDependency);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$shouldUnzip(Companion $this, File file) {
            return $this.shouldUnzip(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

