/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.domain;

import ai.digital.integration.server.common.util.SslUtil;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lai/digital/integration/server/common/domain/AkkaSecured;", "", "serverWorkingDir", "", "(Ljava/lang/String;)V", "confWorkDirPath", "keys", "", "Lai/digital/integration/server/common/domain/AkkaSecured$KeyMeta;", "getKeys", "()Ljava/util/Map;", "trustStoreFilePath", "trustStoreName", "getTrustStoreName", "()Ljava/lang/String;", "truststorePassword", "getTruststorePassword", "confWorkDir", "Ljava/io/File;", "trustStoreFile", "Companion", "KeyMeta", "integration-server-gradle-plugin"})
public final class AkkaSecured {
    @NotNull
    private final String trustStoreName;
    @NotNull
    private final String truststorePassword;
    private final String confWorkDirPath;
    private final String trustStoreFilePath;
    @NotNull
    private final Map<String, KeyMeta> keys;
    @NotNull
    public static final String KEYSTORE_TYPE = "jks";
    @NotNull
    public static final String KEYSTORE_TYPE_EXTENSION = "jks";
    @NotNull
    public static final String MASTER_KEY_NAME = "akka_ssl_master_";
    @NotNull
    public static final String WORKER_KEY_NAME = "akka_ssl_worker_";
    @NotNull
    public static final String SATELLITE_KEY_NAME = "akka_ssl_satellite_";
    @NotNull
    public static final String TRUSTSTORE_NAME = "akka_ssl_truststore_";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getTrustStoreName() {
        return this.trustStoreName;
    }

    @NotNull
    public final String getTruststorePassword() {
        return this.truststorePassword;
    }

    @NotNull
    public final Map<String, KeyMeta> getKeys() {
        return this.keys;
    }

    @NotNull
    public final File confWorkDir() {
        return new File(this.confWorkDirPath);
    }

    @NotNull
    public final File trustStoreFile() {
        return new File(this.trustStoreFilePath);
    }

    public AkkaSecured(@NotNull String serverWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)serverWorkingDir, (String)"serverWorkingDir");
        this.trustStoreName = TRUSTSTORE_NAME;
        this.truststorePassword = SslUtil.Companion.generatePassword(this.trustStoreName);
        this.confWorkDirPath = serverWorkingDir + "/conf";
        this.trustStoreFilePath = this.confWorkDir().toString() + "/" + this.trustStoreName + "." + "jks";
        boolean bl = false;
        this.keys = new LinkedHashMap();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0003R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lai/digital/integration/server/common/domain/AkkaSecured$KeyMeta;", "", "confWorkDir", "Ljava/io/File;", "keyStoreName", "", "(Ljava/io/File;Ljava/lang/String;)V", "keyPassword", "getKeyPassword", "()Ljava/lang/String;", "setKeyPassword", "(Ljava/lang/String;)V", "keyStoreFilePath", "getKeyStoreFilePath", "setKeyStoreFilePath", "keyStorePassword", "getKeyStorePassword", "setKeyStorePassword", "keyStoreFile", "integration-server-gradle-plugin"})
    public static final class KeyMeta {
        @NotNull
        private String keyStorePassword;
        @NotNull
        private String keyPassword;
        @NotNull
        private String keyStoreFilePath;

        @NotNull
        public final File keyStoreFile() {
            return new File(this.keyStoreFilePath);
        }

        @NotNull
        public final String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public final void setKeyStorePassword(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyStorePassword = string;
        }

        @NotNull
        public final String getKeyPassword() {
            return this.keyPassword;
        }

        public final void setKeyPassword(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyPassword = string;
        }

        @NotNull
        public final String getKeyStoreFilePath() {
            return this.keyStoreFilePath;
        }

        public final void setKeyStoreFilePath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.keyStoreFilePath = string;
        }

        public KeyMeta(@NotNull File confWorkDir, @NotNull String keyStoreName) {
            Intrinsics.checkNotNullParameter((Object)confWorkDir, (String)"confWorkDir");
            Intrinsics.checkNotNullParameter((Object)keyStoreName, (String)"keyStoreName");
            this.keyStorePassword = SslUtil.Companion.generatePassword('s' + keyStoreName);
            this.keyPassword = SslUtil.Companion.generatePassword('k' + keyStoreName);
            this.keyStoreFilePath = confWorkDir + '/' + keyStoreName + ".jks";
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/common/domain/AkkaSecured$Companion;", "", "()V", "KEYSTORE_TYPE", "", "KEYSTORE_TYPE_EXTENSION", "MASTER_KEY_NAME", "SATELLITE_KEY_NAME", "TRUSTSTORE_NAME", "WORKER_KEY_NAME", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

