/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks;

import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.deploy.tasks.satellite.ShutdownSatelliteTask;
import ai.digital.integration.server.deploy.tasks.worker.ShutdownWorkersTask;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.deploy.util.SatelliteUtil;
import ai.digital.integration.server.deploy.util.ShutdownUtil;
import ai.digital.integration.server.deploy.util.WorkerUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/ShutdownDeployIntegrationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "shutdown", "", "Companion", "integration-server-gradle-plugin"})
public class ShutdownDeployIntegrationServerTask
extends DefaultTask {
    @NotNull
    public static final String NAME = "shutdownDeployIntegrationServer";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @TaskAction
    public final void shutdown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("About to shutting down Deploy Server.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (!DeployServerUtil.Companion.isDockerBased(project2)) {
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            ShutdownUtil.Companion.shutdownServer(project3);
        }
    }

    public ShutdownDeployIntegrationServerTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isDockerBased(project)) {
            this.dependsOn(new Object[]{"dockerBasedStopDeploy"});
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project2)) {
            this.dependsOn(new Object[]{ShutdownWorkersTask.Companion.getNAME()});
        }
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        if (SatelliteUtil.Companion.hasSatellites(project3)) {
            this.dependsOn(new Object[]{ShutdownSatelliteTask.Companion.getNAME()});
        }
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        if (DbUtil.Companion.isDerby(project4)) {
            this.finalizedBy(new Object[]{"derbyStop"});
        } else {
            this.finalizedBy(new Object[]{"databaseStop"});
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/ShutdownDeployIntegrationServerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

