/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.provision;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.tasks.worker.StartWorkersTask;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.deploy.util.WorkerUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "generateDatasets", "", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "Companion", "integration-server-gradle-plugin"})
public abstract class RunDatasetGenerationTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Running datasets generation on the Deploy server.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        this.generateDatasets(project2, DeployServerUtil.Companion.getServer(project3));
    }

    private final void generateDatasets(Project project, Server server) {
        Iterable $this$forEach$iv = server.getGenerateDatasets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpRequest request;
            String dataset = (String)element$iv;
            boolean bl = false;
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HTTPUtil.Companion.doRequest(DeployServerUtil.Companion.composeUrl(project, "/deployit/generate/" + dataset)).POST(HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                project.getLogger().info("DataSet " + dataset + " created on Deploy server.");
                continue;
            }
            project.getLogger().error(response.body());
        }
    }

    public RunDatasetGenerationTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{"startDeployIntegrationServer"});
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project)) {
            this.dependsOn(new Object[]{StartWorkersTask.Companion.getNAME()});
        }
    }

    static {
        Companion = new Companion(null);
        NAME = "runDatasetGeneration";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDatasetGenerationTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

