/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server;

import ai.digital.integration.server.common.TaskRegistry;
import ai.digital.integration.server.common.domain.Database;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.TaskUtil;
import ai.digital.integration.server.deploy.DeployTaskRegistry;
import ai.digital.integration.server.deploy.util.DeployConfigurationsUtil;
import ai.digital.integration.server.deploy.util.DeployExtensionUtil;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.release.ReleaseTaskRegistry;
import ai.digital.integration.server.release.util.ReleaseExtensionUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import com.xebialabs.gradle.plugins.derby.DerbyExtension;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/IntegrationServerPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "applyDerbyPlugin", "Lorg/gradle/api/Task;", "workDir", "", "applyPlugins", "integration-server-gradle-plugin"})
public final class IntegrationServerPlugin
implements Plugin<Project> {
    private final Task applyDerbyPlugin(Project project, String workDir) {
        Task stopDerbyTask;
        Database database = DbUtil.Companion.getDatabase(project);
        project.getPlugins().apply("derby-ns");
        Object object = project.getExtensions().getByName("derby");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.xebialabs.gradle.plugins.derby.DerbyExtension");
        }
        DerbyExtension derbyExtension = (DerbyExtension)object;
        derbyExtension.setDataDir(workDir);
        Integer n = database.getDerbyPort();
        Intrinsics.checkNotNull((Object)n);
        derbyExtension.setPort(n.intValue());
        Task startDerbyTask = project.getTasks().getByName("derbyStart");
        Task task = stopDerbyTask = project.getTasks().getByName("derbyStop");
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"stopDerbyTask");
        TaskUtil.Companion.dontFailOnException(task);
        List list = stopDerbyTask.getActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stopDerbyTask.actions");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Action action = (Action)element$iv;
            boolean bl = false;
            Task task2 = startDerbyTask.doFirst(action);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"startDerbyTask.doFirst(action)");
            return task2;
        }
        Task task3 = startDerbyTask.mustRunAfter(new Object[]{"applicationConfigurationOverride"});
        Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"startDerbyTask.mustRunAf\u2026urationOverrideTask.NAME)");
        return task3;
    }

    private final void applyPlugins(Project project, String workDir) {
        this.applyDerbyPlugin(project, workDir);
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Configuration serverConfig = (Configuration)project.getConfigurations().create("integrationTestServer");
        DeployConfigurationsUtil.Companion.registerConfigurations(project);
        project.configure((Object)project, GroovyInteroperabilityKt.closureOf((Object)this, (Function1)((Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull Project $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)$this$closureOf, (String)"$receiver");
                DeployExtensionUtil.Companion.createDeployExtension(this.$project);
                ReleaseExtensionUtil.Companion.createReleaseExtension(this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })));
        project.afterEvaluate((Action)new Action<Project>(this, project, serverConfig){
            final /* synthetic */ IntegrationServerPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Configuration $serverConfig;

            public final void execute(Project it) {
                if (DeployServerUtil.Companion.isDeployServerDefined(this.$project)) {
                    DeployExtensionUtil.Companion.initialize(this.$project);
                    Configuration configuration = this.$serverConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"serverConfig");
                    DeployTaskRegistry.Companion.register(this.$project, configuration);
                    IntegrationServerPlugin.access$applyPlugins(this.this$0, this.$project, DeployServerUtil.Companion.getServerWorkingDir(this.$project));
                }
                if (ReleaseServerUtil.Companion.isReleaseServerDefined(this.$project)) {
                    DeployExtensionUtil.Companion.initialize(this.$project);
                    ReleaseTaskRegistry.Companion.register(this.$project);
                    IntegrationServerPlugin.access$applyPlugins(this.this$0, this.$project, ReleaseServerUtil.Companion.getServerWorkingDir(this.$project));
                }
                TaskRegistry.Companion.register(this.$project);
            }
            {
                this.this$0 = integrationServerPlugin;
                this.$project = project;
                this.$serverConfig = configuration;
            }
        });
    }

    public static final /* synthetic */ void access$applyPlugins(IntegrationServerPlugin $this, Project project, String workDir) {
        $this.applyPlugins(project, workDir);
    }
}

