/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.tasks.satellite.DownloadAndExtractSatelliteDistTask;
import ai.digital.integration.server.deploy.util.DeployServerUtil;
import ai.digital.integration.server.deploy.util.SatelliteUtil;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public abstract class SatelliteSyncPluginsTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            if (!satellite.getSyncPlugins()) continue;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            project2.getLogger().lifecycle("Synchronising plugins for satellite " + satellite.getName());
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            FileUtils.deleteDirectory((File)Paths.get(SatelliteUtil.Companion.getSatelliteWorkingDir(project3, satellite), "plugins").toFile());
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            String string = DeployServerUtil.Companion.getServerWorkingDir(project4);
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
            FileUtil.Companion.copyDirs(string, SatelliteUtil.Companion.getSatelliteWorkingDir(project5, satellite), CollectionsKt.listOf((Object[])new String[]{"ext", "hotfix", "plugins"}));
        }
    }

    public SatelliteSyncPluginsTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{DownloadAndExtractSatelliteDistTask.Companion.getNAME()});
    }

    static {
        Companion = new Companion(null);
        NAME = "satelliteSyncPlugins";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/SatelliteSyncPluginsTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

