/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.tasks.DownloadAndExtractServerDistTask;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.LogbackUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/tasks/SetLogbackLevelsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "setLevels", "", "Companion", "integration-server-gradle-plugin"})
public abstract class SetLogbackLevelsTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void setLevels() {
        block3: {
            Server server;
            block2: {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                server = DeployServerUtil.Companion.getServer(project);
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                if (DbUtil.Companion.getDatabase(project2).getLogSql()) break block2;
                Map<String, String> map2 = server.getLogLevels();
                boolean bl = false;
                if (!(!map2.isEmpty())) break block3;
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            project.getLogger().lifecycle("Setting logback level on Deploy Server.");
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            LogbackUtil.Companion.setLogLevels(project3, DeployServerUtil.Companion.getServerWorkingDir(project4), server.getLogLevels());
        }
    }

    public SetLogbackLevelsTask() {
        this.setGroup("Integration Server");
        this.mustRunAfter(new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()});
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return !DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    static {
        Companion = new Companion(null);
        NAME = "setLogbackLevels";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/SetLogbackLevelsTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

