/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import ai.digital.integration.server.domain.Cli;
import ai.digital.integration.server.domain.Test;
import ai.digital.integration.server.util.CliUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.EnvironmentUtil;
import ai.digital.integration.server.util.ExtensionUtil;
import ai.digital.integration.server.util.IdUtil;
import ai.digital.integration.server.util.IntegrationServerUtil;
import ai.digital.integration.server.util.ProcessUtil;
import ai.digital.integration.server.util.PropertyUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/CliUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class CliUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final Cli getCli(@NotNull Project project) {
        return Companion.getCli(project);
    }

    @JvmStatic
    public static final boolean hasCli(@NotNull Project project) {
        return Companion.hasCli(project);
    }

    @JvmStatic
    private static final Integer getDebugPort(Project project, Cli cli) {
        return CliUtil.Companion.getDebugPort(project, cli);
    }

    @JvmStatic
    @NotNull
    public static final String getWorkingDir(@NotNull Project project) {
        return Companion.getWorkingDir(project);
    }

    @JvmStatic
    @NotNull
    public static final File getCliLogFolder(@NotNull Project project) {
        return Companion.getCliLogFolder(project);
    }

    @JvmStatic
    @NotNull
    public static final File getCliExtFolder(@NotNull Project project) {
        return Companion.getCliExtFolder(project);
    }

    @JvmStatic
    @NotNull
    public static final File getCliLogFile(@NotNull Project project, @NotNull String label) {
        return Companion.getCliLogFile(project, label);
    }

    @JvmStatic
    @NotNull
    public static final File getCliBin(@NotNull Project project) {
        return Companion.getCliBin(project);
    }

    @JvmStatic
    private static final String getCliVersion(Project project, Cli cli) {
        return CliUtil.Companion.getCliVersion(project, cli);
    }

    @JvmStatic
    public static final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure) {
        Companion.executeScripts(project, scriptSources, label, secure);
    }

    @JvmStatic
    public static final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure, @NotNull Test test) {
        Companion.executeScripts(project, scriptSources, label, secure, test);
    }

    @JvmStatic
    private static final void runScripts(Project project, List<? extends File> scriptSources, String label, boolean secure, Map<String, String> extraEnvironments, Map<String, String> extraParams, List<? extends File> extraClassPath) {
        CliUtil.Companion.runScripts(project, scriptSources, label, secure, extraEnvironments, extraParams, extraClassPath);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0011H\u0003J\u001f\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0011H\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007Jf\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0003\u00a8\u0006\""}, d2={"Lai/digital/integration/server/util/CliUtil$Companion;", "", "()V", "executeScripts", "", "project", "Lorg/gradle/api/Project;", "scriptSources", "", "Ljava/io/File;", "label", "", "secure", "", "test", "Lai/digital/integration/server/domain/Test;", "getCli", "Lai/digital/integration/server/domain/Cli;", "getCliBin", "getCliExtFolder", "getCliLogFile", "getCliLogFolder", "getCliVersion", "cli", "getDebugPort", "", "(Lorg/gradle/api/Project;Lai/digital/integration/server/domain/Cli;)Ljava/lang/Integer;", "getWorkingDir", "hasCli", "runScripts", "extraEnvironments", "", "extraParams", "extraClassPath", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Cli getCli(@NotNull Project project) {
            Cli cli;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List clis = CollectionsKt.toList((Iterable)((Iterable)ExtensionUtil.Companion.getExtension(project).getClis()));
            Cli cli2 = cli = clis.isEmpty() ? new Cli("default") : (Cli)CollectionsKt.first((List)clis);
            Intrinsics.checkNotNullExpressionValue((Object)cli2, (String)"cli");
            cli.setVersion(this.getCliVersion(project, cli2));
            cli.setDebugPort(this.getDebugPort(project, cli));
            return cli;
        }

        @JvmStatic
        public final boolean hasCli(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return !ExtensionUtil.Companion.getExtension(project).getClis().isEmpty();
        }

        @JvmStatic
        private final Integer getDebugPort(Project project, Cli cli) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "cliDebugPort", cli.getDebugPort()) : null;
        }

        @JvmStatic
        @NotNull
        public final String getWorkingDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String version = this.getCli(project).getVersion();
            String targetDir = IntegrationServerUtil.Companion.getDist(project);
            return ((Object)Paths.get(targetDir, "xl-deploy-" + version + "-cli").toAbsolutePath()).toString();
        }

        @JvmStatic
        @NotNull
        public final File getCliLogFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new File(this.getWorkingDir(project), "log");
        }

        @JvmStatic
        @NotNull
        public final File getCliExtFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new File(this.getWorkingDir(project), "ext");
        }

        @JvmStatic
        @NotNull
        public final File getCliLogFile(@NotNull Project project, @NotNull String label) {
            File file;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            File file2 = file = Paths.get(this.getCliLogFolder(project) + '/' + label + '-' + IdUtil.Companion.shortId() + ".log", new String[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            project.file((Object)file2.getParent()).mkdirs();
            file.createNewFile();
            return file;
        }

        @JvmStatic
        @NotNull
        public final File getCliBin(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            File file = Paths.get(this.getWorkingDir(project), "bin").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(getWorkingDir(project), \"bin\").toFile()");
            return file;
        }

        @JvmStatic
        private final String getCliVersion(Project project, Cli cli) {
            String string;
            if (project.hasProperty("deployCliVersion")) {
                string = String.valueOf(project.property("deployCliVersion"));
            } else {
                CharSequence charSequence = cli.getVersion();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    string = cli.getVersion();
                } else {
                    charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
                    bl = false;
                    bl2 = false;
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        string = DeployServerUtil.Companion.getServer(project).getVersion();
                    } else {
                        project.getLogger().error("CLI Version is not specified");
                        int n = 1;
                        bl = false;
                        System.exit(n);
                        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
            }
            return string;
        }

        @JvmStatic
        public final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(scriptSources, (String)"scriptSources");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Collection collection = scriptSources;
            boolean bl = false;
            if (!collection.isEmpty()) {
                boolean bl2 = false;
                bl2 = false;
                bl2 = false;
                this.runScripts(project, scriptSources, label, secure, MapsKt.emptyMap(), MapsKt.emptyMap(), CollectionsKt.emptyList());
            }
        }

        @JvmStatic
        public final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure, @NotNull Test test) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(scriptSources, (String)"scriptSources");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)test, (String)"test");
            this.runScripts(project, scriptSources, label, secure, test.getEnvironments(), test.getSystemProperties(), test.getExtraClassPath());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final void runScripts(Project project, List<? extends File> scriptSources, String label, boolean secure, Map<String, String> extraEnvironments, Map<String, String> extraParams, List<? extends File> extraClassPath) {
            Object[] $this$mapTo$iv$iv;
            Cli cli = this.getCli(project);
            Map<String, String> $this$filterValues$iv = extraParams;
            boolean $i$f$filterValues = false;
            Map<String, String> result$iv = new LinkedHashMap();
            Map<String, String> map2 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry<String, String> entry$iv : map2.entrySet()) {
                String it = entry$iv.getValue();
                boolean bl2 = false;
                if (!(it != null)) continue;
                ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$map$iv = result$iv;
            boolean $i$f$map2 = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Map.Entry<String, String>> iterator = $this$mapTo$iv$iv;
            boolean bl3 = false;
            Iterator iterator2 = iterator.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                ArrayList arrayList = CollectionsKt.arrayListOf((Object[])new String[]{(String)it.getKey(), (String)it.getValue()});
                collection.add(arrayList);
            }
            List extraParamsAsList = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            List params2 = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.arrayListOf((Object[])new String[]{"-context", DeployServerUtil.Companion.readDeployitConfProperty(project, "http.context.root"), "-expose-proxies", "-password", "admin", "-port", DeployServerUtil.Companion.readDeployitConfProperty(project, "http.port"), "-host", DeployServerUtil.Companion.getHttpHost(), "-socketTimeout", String.valueOf(cli.getSocketTimeout()), "-source", CollectionsKt.joinToString$default((Iterable)scriptSources, (CharSequence)",", null, null, (int)0, null, (Function1)runScripts.params.1.INSTANCE, (int)30, null), "-username", "admin"}), (Iterable)extraParamsAsList));
            if (DeployServerUtil.Companion.isTls(project) || secure) {
                Collection $i$f$map2 = params2;
                $this$mapTo$iv$iv = new String[]{"-secure"};
                boolean destination$iv$iv2 = false;
                CollectionsKt.addAll((Collection)$i$f$map2, (Object[])$this$mapTo$iv$iv);
            }
            File workDir = this.getCliBin(project);
            File scriptLogFile = this.getCliLogFile(project, label);
            String ext = Os.isFamily((String)"windows") ? "cmd" : "sh";
            String commandLine = workDir + " ./cli." + ext + ' ' + CollectionsKt.joinToString$default((Iterable)params2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            project.getLogger().lifecycle("Running this command now: " + commandLine + ", logs can be found in " + scriptLogFile);
            Map environment = MapsKt.plus(extraEnvironments, EnvironmentUtil.Companion.getCliEnv(project, cli, extraParams, extraClassPath));
            project.getLogger().info("Starting worker with environment: " + environment);
            ProcessUtil.Companion.execAndCheck(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"command", (Object)"cli"), TuplesKt.to((Object)"environment", (Object)environment), TuplesKt.to((Object)"params", (Object)params2), TuplesKt.to((Object)"redirectTo", (Object)scriptLogFile), TuplesKt.to((Object)"wait", (Object)true), TuplesKt.to((Object)"workDir", (Object)workDir)}), scriptLogFile);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

