/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.tasks.ApplicationConfigurationOverrideTask;
import ai.digital.integration.server.tasks.CentralConfigurationTask;
import ai.digital.integration.server.tasks.CheckUILibVersionsTask;
import ai.digital.integration.server.tasks.CopyOverlaysTask;
import ai.digital.integration.server.tasks.CopyServerBuildArtifactsTask;
import ai.digital.integration.server.tasks.DownloadAndExtractServerDistTask;
import ai.digital.integration.server.tasks.GenerateSecureAkkaKeysTask;
import ai.digital.integration.server.tasks.PrepareDeployTask;
import ai.digital.integration.server.tasks.SetLogbackLevelsTask;
import ai.digital.integration.server.tasks.TlsApplicationConfigurationOverrideTask;
import ai.digital.integration.server.tasks.YamlPatchTask;
import ai.digital.integration.server.tasks.cli.CopyCliBuildArtifactsTask;
import ai.digital.integration.server.tasks.cli.RunCliTask;
import ai.digital.integration.server.tasks.database.DatabaseStartTask;
import ai.digital.integration.server.tasks.database.ImportDbUnitDataTask;
import ai.digital.integration.server.tasks.database.PrepareDatabaseTask;
import ai.digital.integration.server.tasks.mq.StartMqTask;
import ai.digital.integration.server.tasks.provision.RunDatasetGenerationTask;
import ai.digital.integration.server.tasks.provision.RunDevOpsAsCodeTask;
import ai.digital.integration.server.tasks.satellite.StartSatelliteTask;
import ai.digital.integration.server.tasks.worker.StartWorkersTask;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.EnvironmentUtil;
import ai.digital.integration.server.util.ProcessUtil;
import ai.digital.integration.server.util.SatelliteUtil;
import ai.digital.integration.server.util.ShutdownUtil;
import ai.digital.integration.server.util.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lai/digital/integration/server/tasks/StartIntegrationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "allowToWriteMountedHostFolders", "", "getBinDir", "Ljava/io/File;", "hasToBeStartedFromClasspath", "", "server", "Lai/digital/integration/server/domain/Server;", "launch", "maybeTearDown", "start", "Ljava/lang/Process;", "startServer", "Companion", "integration-server-gradle-plugin"})
public class StartIntegrationServerTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    private final File getBinDir() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), "bin").toFile();
    }

    private final Process startServer(Server server) {
        File file;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Launching server");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getServerEnv(project2, server);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        project3.getLogger().info("Starting server with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0));
        if (server.getStdoutFileName() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            file = new File(stringBuilder.append(DeployServerUtil.Companion.getLogDir(project4).toString()).append("/").append(server.getStdoutFileName()).toString());
        } else {
            file = null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirectTo", (Object)file);
        pairArray[3] = TuplesKt.to((Object)"environment", environment);
        pairArray[4] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object)"-force-upgrades"));
        pairArray[5] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir());
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        Process process = ProcessUtil.Companion.exec(map2);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        project5.getLogger().lifecycle("Launched server on PID [" + String.valueOf(process.pid()) + "] with command [" + process.info().commandLine().orElse("") + "].");
        return process;
    }

    private final boolean hasToBeStartedFromClasspath(Server server) {
        return server.getRuntimeDirectory() != null;
    }

    private final Process start(Server server) {
        Process process;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (!DeployServerUtil.Companion.isDockerBased(project)) {
            this.maybeTearDown();
            if (this.hasToBeStartedFromClasspath(server)) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                process = DeployServerUtil.Companion.startServerFromClasspath(project2);
            } else {
                process = this.startServer(server);
            }
        } else {
            this.getProject().exec((Action)new Action<ExecSpec>(this){
                final /* synthetic */ StartIntegrationServerTask this$0;

                public final void execute(ExecSpec it) {
                    ExecSpec execSpec = it;
                    Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                    execSpec.setExecutable("docker-compose");
                    Object[] objectArray = new String[4];
                    objectArray[0] = "-f";
                    Project project = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    String string = DeployServerUtil.Companion.getResolvedDockerFile(project).toFile().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResolvedDockerFile(project).toFile().toString()");
                    objectArray[1] = string;
                    objectArray[2] = "up";
                    objectArray[3] = "-d";
                    it.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
                {
                    this.this$0 = startIntegrationServerTask;
                }
            });
            process = null;
        }
        return process;
    }

    private final void maybeTearDown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ShutdownUtil.Companion.shutdownServer(project);
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DeployServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        project2.getLogger().lifecycle("About to launch Deploy Server on port " + String.valueOf(server.getHttpPort()) + ".");
        this.allowToWriteMountedHostFolders();
        Process process = this.start(server);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        DeployServerUtil.Companion.waitForBoot(project3, process);
    }

    public StartIntegrationServerTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[13];
        objectArray[0] = ApplicationConfigurationOverrideTask.Companion.getNAME();
        objectArray[1] = CentralConfigurationTask.Companion.getNAME();
        objectArray[2] = CheckUILibVersionsTask.Companion.getNAME();
        objectArray[3] = CopyCliBuildArtifactsTask.Companion.getNAME();
        objectArray[4] = CopyServerBuildArtifactsTask.Companion.getNAME();
        objectArray[5] = CopyOverlaysTask.Companion.getNAME();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        objectArray[6] = DbUtil.Companion.isDerby(project) ? "derbyStart" : DatabaseStartTask.Companion.getNAME();
        objectArray[7] = DownloadAndExtractServerDistTask.Companion.getNAME();
        objectArray[8] = PrepareDatabaseTask.Companion.getNAME();
        objectArray[9] = PrepareDeployTask.Companion.getNAME();
        objectArray[10] = SetLogbackLevelsTask.Companion.getNAME();
        objectArray[11] = StartMqTask.Companion.getNAME();
        objectArray[12] = YamlPatchTask.Companion.getNAME();
        final List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<StartIntegrationServerTask, Unit>(){

            public final void invoke(@NotNull StartIntegrationServerTask $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$receiver");
                Project project = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (DeployServerUtil.Companion.isTls(project)) {
                    dependencies.add(TlsApplicationConfigurationOverrideTask.Companion.getNAME());
                }
                Project project2 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                if (DeployServerUtil.Companion.isAkkaSecured(project2)) {
                    dependencies.add(GenerateSecureAkkaKeysTask.Companion.getNAME());
                }
                Project project3 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                if (DeployServerUtil.Companion.isAkkaSecured(project3)) {
                    dependencies.add(GenerateSecureAkkaKeysTask.Companion.getNAME());
                }
                $this$closureOf.dependsOn(new Object[]{dependencies});
                Project project4 = $this$closureOf.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                if (!DeployServerUtil.Companion.isDockerBased(project4)) {
                    Project project5 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                    if (WorkerUtil.Companion.hasWorkers(project5)) {
                        $this$closureOf.finalizedBy(new Object[]{StartWorkersTask.Companion.getNAME()});
                    }
                    Project project6 = $this$closureOf.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                    if (SatelliteUtil.Companion.hasSatellites(project6)) {
                        $this$closureOf.finalizedBy(new Object[]{StartSatelliteTask.Companion.getNAME()});
                    }
                }
                $this$closureOf.finalizedBy(new Object[]{ImportDbUnitDataTask.Companion.getNAME()});
                $this$closureOf.finalizedBy(new Object[]{RunDevOpsAsCodeTask.Companion.getNAME()});
                $this$closureOf.finalizedBy(new Object[]{RunDatasetGenerationTask.Companion.getNAME()});
                $this$closureOf.finalizedBy(new Object[]{RunCliTask.Companion.getNAME()});
            }
        })));
    }

    static {
        Companion = new Companion(null);
        NAME = "startIntegrationServer";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/StartIntegrationServerTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

