/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.tasks.CentralConfigurationTask;
import ai.digital.integration.server.tasks.CheckUILibVersionsTask;
import ai.digital.integration.server.tasks.CopyServerBuildArtifactsTask;
import ai.digital.integration.server.tasks.DownloadAndExtractServerDistTask;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.ExtensionUtil;
import ai.digital.integration.server.util.OverlaysUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/tasks/CopyOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "()V", "Companion", "integration-server-gradle-plugin"})
public abstract class CopyOverlaysTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    public CopyOverlaysTask() {
        this.setGroup("Integration Server");
        this.mustRunAfter(new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()});
        this.mustRunAfter(new Object[]{CentralConfigurationTask.Companion.getNAME()});
        this.mustRunAfter(new Object[]{CopyServerBuildArtifactsTask.Companion.getNAME()});
        this.finalizedBy(new Object[]{CheckUILibVersionsTask.Companion.getNAME()});
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public final void execute(Project it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Server server = DeployServerUtil.Companion.getServer(project);
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                project2.getLogger().lifecycle("Copying overlays on Deploy server " + server.getName());
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                OverlaysUtil.Companion.addDatabaseDependency(project3, server);
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                OverlaysUtil.Companion.addMqDependency(project4, server);
                Map<String, List<Object>> $this$forEach$iv = server.getOverlays();
                boolean $i$f$forEach = false;
                Map<String, List<Object>> map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<String, List<Object>>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, List<Object>> element$iv;
                    Map.Entry<String, List<Object>> overlay = element$iv = iterator.next();
                    boolean bl2 = false;
                    Project project5 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                    Task task = (Task)this;
                    Project project6 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                    boolean bl3 = false;
                    OverlaysUtil.Companion.defineOverlay(project5, task, DeployServerUtil.Companion.getServerWorkingDir(project6), ExtensionUtil.Companion.getIS_EXTENSION_NAME(), overlay, new ArrayList());
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        NAME = "copyOverlays";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/CopyOverlaysTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

