/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.tasks.CopyOverlaysTask;
import ai.digital.integration.server.tasks.CopyServerBuildArtifactsTask;
import ai.digital.integration.server.util.DeployServerUtil;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import groovy.json.JsonSlurper;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007JB\u0010\u0005\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\b2\u001a\u0010\u000b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0006H\u0002J2\u0010\f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002J,\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J8\u0010\u0016\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00062\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0006H\u0002J$\u0010\u0018\u001a\u00020\b2\u001a\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0006H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001f"}, d2={"Lai/digital/integration/server/tasks/CheckUILibVersionsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "check", "", "checkForMismatch", "", "", "", "", "libName", "plugins", "collectPluginMetadata", "project", "Lorg/gradle/api/Project;", "files", "Ljava/io/File;", "extractPluginMetadata", "xldpZip", "Ljava/util/zip/ZipFile;", "internalJarEntry", "Ljava/util/zip/ZipEntry;", "findMismatches", "metadata", "formatErrorMessage", "mismatches", "parsePluginName", "stream", "Ljava/util/zip/ZipInputStream;", "parseVersions", "Companion", "integration-server-gradle-plugin"})
public class CheckUILibVersionsTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    private final Object parseVersions(ZipInputStream stream) {
        JsonSlurper jsonSlurper = new JsonSlurper();
        return jsonSlurper.parse(IOUtils.toByteArray((InputStream)stream));
    }

    private final String parsePluginName(ZipInputStream stream) {
        String string;
        Object v1;
        int n;
        Object object;
        String prefix;
        block4: {
            prefix = "plugin=";
            String string2 = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IOUtils.toString(stream, Charset.defaultCharset())");
            object = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            n = 0;
            Iterable iterable = object;
            boolean bl = false;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        String string3 = v1;
        if (string3 != null) {
            object = string3;
            n = prefix.length();
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)object2).substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Map<String, Object>> extractPluginMetadata(ZipFile xldpZip, ZipEntry internalJarEntry) {
        ZipInputStream zipStream = new ZipInputStream(xldpZip.getInputStream(internalJarEntry));
        Closeable closeable = zipStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            List list;
            ZipInputStream stream = (ZipInputStream)closeable;
            boolean bl3 = false;
            ZipEntry entry = stream.getNextEntry();
            String pluginName = null;
            Object versions = null;
            while (entry != null && (pluginName == null || versions == null)) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                if (StringsKt.endsWith$default((String)string, (String)"-metadata.json", (boolean)false, (int)2, null)) {
                    versions = this.parseVersions(stream);
                }
                if (Intrinsics.areEqual((Object)entry.getName(), (Object)"plugin-version.properties")) {
                    pluginName = this.parsePluginName(stream);
                }
                entry = stream.getNextEntry();
            }
            if (pluginName != null && versions != null) {
                list = CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"plugin", pluginName), TuplesKt.to((Object)"versions", (Object)versions)}));
            } else {
                boolean bl4 = false;
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> checkForMismatch(String libName, List<? extends Map<String, ? extends Object>> plugins) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = plugins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        if (iterator.hasNext()) {
            List list;
            void plugin;
            Object item$iv$iv = iterator.next();
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = plugin.get("versions");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Object version = ((Map)v).get(libName);
            if (version != null) {
                list = CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"plugin", plugin.get("plugin")), TuplesKt.to((Object)"version", version)}));
            } else {
                boolean bl2 = false;
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        List pluginVersions = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        Iterable $this$flatMap$iv = pluginVersions;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map current = (Map)element$iv$iv;
            boolean bl = false;
            Object v = current.get("version");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String version = (String)v;
            Iterable list$iv$iv = CollectionsKt.listOf((Object)version);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv2;
        boolean bl = false;
        boolean mismatch = !collection.isEmpty();
        return mismatch ? pluginVersions : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> collectPluginMetadata(Project project, List<? extends File> files) {
        void $this$mapTo$iv$iv;
        File file;
        Iterable $this$filterTo$iv$iv;
        project.getLogger().lifecycle("Collecting plugins metadata");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            file = (File)element$iv$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith$default((String)string, (String)".xldp", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        if (iterator.hasNext()) {
            List<Map<String, Object>> list;
            void plugin;
            Object item$iv$iv = iterator.next();
            file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            project.getLogger().lifecycle("Extracting plugin's metadata from the plugin " + plugin);
            if (plugin.length() > 0L) {
                Object v5;
                ZipFile xldpZip;
                block7: {
                    xldpZip = new ZipFile((File)plugin);
                    Enumeration<? extends ZipEntry> enumeration = xldpZip.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"xldpZip.entries()");
                    Object object = enumeration;
                    boolean bl2 = false;
                    ArrayList<? extends ZipEntry> arrayList = Collections.list(object);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                    object = arrayList;
                    bl2 = false;
                    Object object2 = object;
                    boolean bl3 = false;
                    Iterator iterator2 = object2.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        ZipEntry it = (ZipEntry)t;
                        boolean bl4 = false;
                        ZipEntry zipEntry = it;
                        Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"it");
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                        v5 = t;
                        break block7;
                    }
                    v5 = null;
                }
                ZipEntry internalJarEntry = v5;
                if (internalJarEntry != null) {
                    list = this.extractPluginMetadata(xldpZip, internalJarEntry);
                } else {
                    boolean bl5 = false;
                    list = CollectionsKt.emptyList();
                }
            } else {
                project.getLogger().lifecycle("Skipping the check of " + plugin + " as the content is empty.");
                boolean bl6 = false;
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> findMismatches(List<? extends Map<String, ? extends Object>> metadata) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = metadata;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map map2 = (Map)element$iv$iv;
            boolean bl = false;
            Object v = map2.get("versions");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            list$iv$iv = ((Map)v).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set allLibs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = allLibs;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        if (iterator.hasNext()) {
            void lib;
            Object item$iv$iv = iterator.next();
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Map<String, Object>> mismatch = this.checkForMismatch((String)lib, metadata);
            return mismatch != null ? CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"lib", (Object)lib), TuplesKt.to((Object)"versions", mismatch)})) : CollectionsKt.emptyList();
        }
        return (List)destination$iv$iv;
    }

    private final String formatErrorMessage(List<? extends Map<String, ? extends Object>> mismatches) {
        AsciiTable table = new AsciiTable();
        table.addRule();
        table.addRow(new Object[]{null, "Version(s) mismatch has been detected"}).setTextAlignment(TextAlignment.CENTER);
        table.addRule();
        Iterable $this$forEach$iv = mismatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map current = (Map)element$iv;
            boolean bl = false;
            table.addRow(new Object[]{null, current.get("lib")}).setTextAlignment(TextAlignment.CENTER);
            table.addRule();
            Object v = current.get("versions");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any?>>");
            }
            List versions = (List)v;
            Iterable $this$forEach$iv2 = versions;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map descriptor = (Map)element$iv2;
                boolean bl2 = false;
                table.addRow(new Object[]{descriptor.get("plugin"), descriptor.get("version")});
                table.addRule();
            }
        }
        return "/n" + table.render();
    }

    @TaskAction
    public final void check() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Checking UI Lib Versions on Deploy server");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Object[] plugins = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project2), new String[0]).resolve("plugins").resolve("xld-official").toFile().listFiles();
        if (plugins != null) {
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            List<Map<String, Object>> metadata = this.collectPluginMetadata(project3, ArraysKt.toList((Object[])plugins));
            List<Map<String, Object>> mismatches = this.findMismatches(metadata);
            Collection collection = mismatches;
            boolean bl = false;
            if (!collection.isEmpty()) {
                throw (Throwable)new GradleException(this.formatErrorMessage(mismatches));
            }
        } else {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            project4.getLogger().lifecycle("No plugins have been found on Deploy Server. Skipping checking versions for UI libraries.");
        }
    }

    public CheckUILibVersionsTask() {
        this.setGroup("Integration Server");
        final List dependencies = CollectionsKt.listOf((Object[])new String[]{CopyOverlaysTask.Companion.getNAME(), CopyServerBuildArtifactsTask.Companion.getNAME()});
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<CheckUILibVersionsTask, Unit>(){

            public final void invoke(@NotNull CheckUILibVersionsTask $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$receiver");
                $this$closureOf.dependsOn(new Object[]{dependencies});
                $this$closureOf.onlyIf(GroovyInteroperabilityKt.closureOf((Object)((Object)$this$closureOf), (Function1)1.INSTANCE));
            }
        })));
    }

    static {
        Companion = new Companion(null);
        NAME = "checkUILibVersions";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/CheckUILibVersionsTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

