/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server;

import ai.digital.integration.server.domain.Database;
import ai.digital.integration.server.tasks.ApplicationConfigurationOverrideTask;
import ai.digital.integration.server.tasks.CentralConfigurationTask;
import ai.digital.integration.server.tasks.CheckUILibVersionsTask;
import ai.digital.integration.server.tasks.CopyOverlaysTask;
import ai.digital.integration.server.tasks.CopyServerBuildArtifactsTask;
import ai.digital.integration.server.tasks.DockerBasedStopDeployTask;
import ai.digital.integration.server.tasks.DownloadAndExtractDbUnitDataDistTask;
import ai.digital.integration.server.tasks.DownloadAndExtractServerDistTask;
import ai.digital.integration.server.tasks.GenerateSecureAkkaKeysTask;
import ai.digital.integration.server.tasks.IntegrationTestsTask;
import ai.digital.integration.server.tasks.PrepareDeployTask;
import ai.digital.integration.server.tasks.SetLogbackLevelsTask;
import ai.digital.integration.server.tasks.ShutdownIntegrationServerTask;
import ai.digital.integration.server.tasks.StartIntegrationServerTask;
import ai.digital.integration.server.tasks.TlsApplicationConfigurationOverrideTask;
import ai.digital.integration.server.tasks.YamlPatchTask;
import ai.digital.integration.server.tasks.anonymizer.ExportDatabaseTask;
import ai.digital.integration.server.tasks.cli.CliCleanDefaultExtTask;
import ai.digital.integration.server.tasks.cli.CliOverlaysTask;
import ai.digital.integration.server.tasks.cli.CopyCliBuildArtifactsTask;
import ai.digital.integration.server.tasks.cli.DownloadAndExtractCliDistTask;
import ai.digital.integration.server.tasks.cli.RunCliTask;
import ai.digital.integration.server.tasks.database.DatabaseStartTask;
import ai.digital.integration.server.tasks.database.DatabaseStopTask;
import ai.digital.integration.server.tasks.database.ImportDbUnitDataTask;
import ai.digital.integration.server.tasks.database.PrepareDatabaseTask;
import ai.digital.integration.server.tasks.gitlab.GitlabStartTask;
import ai.digital.integration.server.tasks.gitlab.GitlabStopTask;
import ai.digital.integration.server.tasks.mq.ShutdownMqTask;
import ai.digital.integration.server.tasks.mq.StartMqTask;
import ai.digital.integration.server.tasks.pluginManager.StartPluginManagerTask;
import ai.digital.integration.server.tasks.provision.RunDatasetGenerationTask;
import ai.digital.integration.server.tasks.provision.RunDevOpsAsCodeTask;
import ai.digital.integration.server.tasks.satellite.DownloadAndExtractSatelliteDistTask;
import ai.digital.integration.server.tasks.satellite.PrepareSatellitesTask;
import ai.digital.integration.server.tasks.satellite.SatelliteOverlaysTask;
import ai.digital.integration.server.tasks.satellite.SatelliteSyncPluginsTask;
import ai.digital.integration.server.tasks.satellite.ShutdownSatelliteTask;
import ai.digital.integration.server.tasks.satellite.StartSatelliteTask;
import ai.digital.integration.server.tasks.worker.CopyIntegrationServerTask;
import ai.digital.integration.server.tasks.worker.DownloadAndExtractWorkerDistTask;
import ai.digital.integration.server.tasks.worker.SetWorkersLogbackLevelsTask;
import ai.digital.integration.server.tasks.worker.ShutdownWorkersTask;
import ai.digital.integration.server.tasks.worker.StartWorkersTask;
import ai.digital.integration.server.tasks.worker.SyncServerPluginsWithWorkerTask;
import ai.digital.integration.server.tasks.worker.WorkerOverlaysTask;
import ai.digital.integration.server.util.ConfigurationsUtil;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.ExtensionUtil;
import ai.digital.integration.server.util.TaskUtil;
import com.xebialabs.gradle.plugins.derby.DerbyExtension;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/IntegrationServerPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "applyDerbyPlugin", "Lorg/gradle/api/Task;", "applyPlugins", "createTasks", "itcfg", "Lorg/gradle/api/artifacts/Configuration;", "integration-server-gradle-plugin"})
public final class IntegrationServerPlugin
implements Plugin<Project> {
    private final void createTasks(Project project, Configuration itcfg) {
        project.getTasks().create(CliCleanDefaultExtTask.Companion.getNAME(), CliCleanDefaultExtTask.class);
        project.getTasks().create(CopyCliBuildArtifactsTask.Companion.getNAME(), CopyCliBuildArtifactsTask.class);
        project.getTasks().create(CliOverlaysTask.Companion.getNAME(), CliOverlaysTask.class);
        project.getTasks().create(DownloadAndExtractCliDistTask.Companion.getNAME(), DownloadAndExtractCliDistTask.class);
        project.getTasks().create(RunCliTask.Companion.getNAME(), RunCliTask.class);
        project.getTasks().create(DatabaseStartTask.Companion.getNAME(), DatabaseStartTask.class);
        project.getTasks().create(DatabaseStopTask.Companion.getNAME(), DatabaseStopTask.class);
        project.getTasks().create(ApplicationConfigurationOverrideTask.Companion.getNAME(), ApplicationConfigurationOverrideTask.class);
        project.getTasks().create(CentralConfigurationTask.Companion.getNAME(), CentralConfigurationTask.class);
        project.getTasks().create(CheckUILibVersionsTask.Companion.getNAME(), CheckUILibVersionsTask.class);
        project.getTasks().create(CopyServerBuildArtifactsTask.Companion.getNAME(), CopyServerBuildArtifactsTask.class);
        project.getTasks().create(CopyOverlaysTask.Companion.getNAME(), CopyOverlaysTask.class);
        project.getTasks().create(DockerBasedStopDeployTask.Companion.getNAME(), DockerBasedStopDeployTask.class);
        project.getTasks().create(DownloadAndExtractDbUnitDataDistTask.Companion.getNAME(), DownloadAndExtractDbUnitDataDistTask.class);
        project.getTasks().create(DownloadAndExtractServerDistTask.Companion.getNAME(), DownloadAndExtractServerDistTask.class);
        project.getTasks().create(ExportDatabaseTask.Companion.getNAME(), ExportDatabaseTask.class);
        project.getTasks().create(GenerateSecureAkkaKeysTask.Companion.getNAME(), GenerateSecureAkkaKeysTask.class);
        project.getTasks().create(ImportDbUnitDataTask.Companion.getNAME(), ImportDbUnitDataTask.class);
        project.getTasks().create(PrepareDatabaseTask.Companion.getNAME(), PrepareDatabaseTask.class);
        project.getTasks().create(PrepareDeployTask.Companion.getNAME(), PrepareDeployTask.class);
        project.getTasks().create(RunDatasetGenerationTask.Companion.getNAME(), RunDatasetGenerationTask.class);
        project.getTasks().create(RunDevOpsAsCodeTask.Companion.getNAME(), RunDevOpsAsCodeTask.class);
        project.getTasks().create(SetLogbackLevelsTask.Companion.getNAME(), SetLogbackLevelsTask.class);
        project.getTasks().create(TlsApplicationConfigurationOverrideTask.Companion.getNAME(), TlsApplicationConfigurationOverrideTask.class);
        project.getTasks().create(YamlPatchTask.Companion.getNAME(), YamlPatchTask.class);
        project.getTasks().create(GitlabStartTask.Companion.getNAME(), GitlabStartTask.class);
        project.getTasks().create(GitlabStopTask.Companion.getNAME(), GitlabStopTask.class);
        project.getTasks().create(ShutdownIntegrationServerTask.Companion.getNAME(), ShutdownIntegrationServerTask.class);
        ((StartIntegrationServerTask)project.getTasks().create(StartIntegrationServerTask.Companion.getNAME(), StartIntegrationServerTask.class)).dependsOn(new Object[]{itcfg});
        project.getTasks().create(ShutdownMqTask.Companion.getNAME(), ShutdownMqTask.class);
        project.getTasks().create(StartMqTask.Companion.getNAME(), StartMqTask.class);
        project.getTasks().create(StartPluginManagerTask.Companion.getNAME(), StartPluginManagerTask.class);
        project.getTasks().create(DownloadAndExtractSatelliteDistTask.Companion.getNAME(), DownloadAndExtractSatelliteDistTask.class);
        project.getTasks().create(PrepareSatellitesTask.Companion.getNAME(), PrepareSatellitesTask.class);
        project.getTasks().create(SatelliteOverlaysTask.Companion.getNAME(), SatelliteOverlaysTask.class);
        project.getTasks().create(SatelliteSyncPluginsTask.Companion.getNAME(), SatelliteSyncPluginsTask.class);
        project.getTasks().create(ShutdownSatelliteTask.Companion.getNAME(), ShutdownSatelliteTask.class);
        project.getTasks().create(StartSatelliteTask.Companion.getNAME(), StartSatelliteTask.class);
        project.getTasks().create(CopyIntegrationServerTask.Companion.getNAME(), CopyIntegrationServerTask.class);
        project.getTasks().create(SyncServerPluginsWithWorkerTask.Companion.getNAME(), SyncServerPluginsWithWorkerTask.class);
        project.getTasks().create(DownloadAndExtractWorkerDistTask.Companion.getNAME(), DownloadAndExtractWorkerDistTask.class);
        project.getTasks().create(SetWorkersLogbackLevelsTask.Companion.getNAME(), SetWorkersLogbackLevelsTask.class);
        project.getTasks().create(ShutdownWorkersTask.Companion.getNAME(), ShutdownWorkersTask.class);
        project.getTasks().create(StartWorkersTask.Companion.getNAME(), StartWorkersTask.class);
        project.getTasks().create(WorkerOverlaysTask.Companion.getNAME(), WorkerOverlaysTask.class);
        project.getTasks().create(IntegrationTestsTask.Companion.getNAME(), IntegrationTestsTask.class);
    }

    private final Task applyDerbyPlugin(Project project) {
        Task stopDerbyTask;
        Database database = DbUtil.Companion.getDatabase(project);
        project.getPlugins().apply("derby-ns");
        Object object = project.getExtensions().getByName("derby");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.xebialabs.gradle.plugins.derby.DerbyExtension");
        }
        DerbyExtension derbyExtension = (DerbyExtension)object;
        derbyExtension.setDataDir(DeployServerUtil.Companion.getServerWorkingDir(project));
        Integer n = database.getDerbyPort();
        Intrinsics.checkNotNull((Object)n);
        derbyExtension.setPort(n.intValue());
        Task startDerbyTask = project.getTasks().getByName("derbyStart");
        Task task = stopDerbyTask = project.getTasks().getByName("derbyStop");
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"stopDerbyTask");
        TaskUtil.Companion.dontFailOnException(task);
        List list = stopDerbyTask.getActions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"stopDerbyTask.actions");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Action action = (Action)element$iv;
            boolean bl = false;
            Task task2 = startDerbyTask.doFirst(action);
            Intrinsics.checkNotNullExpressionValue((Object)task2, (String)"startDerbyTask.doFirst(action)");
            return task2;
        }
        Task task3 = startDerbyTask.mustRunAfter(new Object[]{ApplicationConfigurationOverrideTask.Companion.getNAME()});
        Intrinsics.checkNotNullExpressionValue((Object)task3, (String)"startDerbyTask.mustRunAf\u2026urationOverrideTask.NAME)");
        return task3;
    }

    private final void applyPlugins(Project project) {
        this.applyDerbyPlugin(project);
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Configuration serverConfig = (Configuration)project.getConfigurations().create(ConfigurationsUtil.Companion.getDEPLOY_SERVER());
        ConfigurationsUtil.Companion.registerConfigurations(project);
        project.configure((Object)project, GroovyInteroperabilityKt.closureOf((Object)this, (Function1)((Function1)new Function1<Project, Unit>(project){
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull Project $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)$this$closureOf, (String)"$receiver");
                ExtensionUtil.Companion.createExtension(this.$project);
            }
            {
                this.$project = project;
                super(1);
            }
        })));
        project.afterEvaluate((Action)new Action<Project>(this, project, serverConfig){
            final /* synthetic */ IntegrationServerPlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Configuration $serverConfig;

            public final void execute(Project it) {
                if (DeployServerUtil.Companion.isServerDefined(this.$project)) {
                    ExtensionUtil.Companion.initialize(this.$project);
                    Configuration configuration = this.$serverConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"serverConfig");
                    IntegrationServerPlugin.access$createTasks(this.this$0, this.$project, configuration);
                    IntegrationServerPlugin.access$applyPlugins(this.this$0, this.$project);
                } else {
                    this.$project.getLogger().lifecycle("Nothing to do, a configuration for a server has not found.");
                }
            }
            {
                this.this$0 = integrationServerPlugin;
                this.$project = project;
                this.$serverConfig = configuration;
            }
        });
    }

    public static final /* synthetic */ void access$createTasks(IntegrationServerPlugin $this, Project project, Configuration itcfg) {
        $this.createTasks(project, itcfg);
    }

    public static final /* synthetic */ void access$applyPlugins(IntegrationServerPlugin $this, Project project) {
        $this.applyPlugins(project);
    }
}

