/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks.worker;

import ai.digital.integration.server.domain.Worker;
import ai.digital.integration.server.tasks.worker.CopyIntegrationServerTask;
import ai.digital.integration.server.tasks.worker.DownloadAndExtractWorkerDistTask;
import ai.digital.integration.server.tasks.worker.SetWorkersLogbackLevelsTask;
import ai.digital.integration.server.tasks.worker.SyncServerPluginsWithWorkerTask;
import ai.digital.integration.server.util.OverlaysUtil;
import ai.digital.integration.server.util.WorkerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/tasks/worker/WorkerOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "()V", "Companion", "integration-server-gradle-plugin"})
public abstract class WorkerOverlaysTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    private static final String PREFIX;
    @NotNull
    public static final Companion Companion;

    public WorkerOverlaysTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasSlimWorkers(project)) {
            this.dependsOn(new Object[]{DownloadAndExtractWorkerDistTask.Companion.getNAME()});
            this.dependsOn(new Object[]{SyncServerPluginsWithWorkerTask.Companion.getNAME()});
            this.dependsOn(new Object[]{SetWorkersLogbackLevelsTask.Companion.getNAME()});
            this.mustRunAfter(new Object[]{DownloadAndExtractWorkerDistTask.Companion.getNAME()});
            this.mustRunAfter(new Object[]{SyncServerPluginsWithWorkerTask.Companion.getNAME()});
            this.mustRunAfter(new Object[]{SetWorkersLogbackLevelsTask.Companion.getNAME()});
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasNonSlimWorkers(project2)) {
            this.dependsOn(new Object[]{CopyIntegrationServerTask.Companion.getNAME()});
            this.dependsOn(new Object[]{SetWorkersLogbackLevelsTask.Companion.getNAME()});
            this.mustRunAfter(new Object[]{CopyIntegrationServerTask.Companion.getNAME()});
            this.mustRunAfter(new Object[]{SetWorkersLogbackLevelsTask.Companion.getNAME()});
        }
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public final void execute(Project it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Worker worker = (Worker)element$iv;
                    boolean bl = false;
                    if (worker.getSlimDistribution()) {
                        Project project2 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                        OverlaysUtil.Companion.addDatabaseDependency(project2, worker);
                        Project project3 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                        OverlaysUtil.Companion.addMqDependency(project3, worker);
                    }
                    Map<String, List<Object>> map2 = worker.getOverlays();
                    boolean bl2 = false;
                    if (!map2.isEmpty()) {
                        Project project4 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                        if (!WorkerUtil.Companion.isExternalRuntimeWorker(project4, worker)) {
                            this.getLogger().warn("Overlays on the worker " + worker.getName() + " are ignored because worker's runtime directory is same to the master.");
                            continue;
                        }
                    }
                    Map<String, List<Object>> $this$forEach$iv2 = worker.getOverlays();
                    boolean $i$f$forEach2 = false;
                    Map<String, List<Object>> map3 = $this$forEach$iv2;
                    boolean bl3 = false;
                    Iterator<Map.Entry<String, List<Object>>> iterator = map3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, List<Object>> element$iv2;
                        Map.Entry<String, List<Object>> overlay = element$iv2 = iterator.next();
                        boolean bl4 = false;
                        Project project5 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
                        Task task = (Task)this;
                        Project project6 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                        OverlaysUtil.Companion.defineOverlay(project5, task, WorkerUtil.Companion.getWorkerWorkingDir(project6, worker), Companion.getPREFIX(), overlay, CollectionsKt.arrayListOf((Object[])new String[]{DownloadAndExtractWorkerDistTask.Companion.getNAME() + worker.getName(), SyncServerPluginsWithWorkerTask.Companion.getNAME(), SetWorkersLogbackLevelsTask.Companion.getNAME()}));
                    }
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        NAME = "workerOverlays";
        PREFIX = "worker";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @NotNull
    public static final String getPREFIX() {
        Companion companion = Companion;
        return PREFIX;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/tasks/worker/WorkerOverlaysTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "PREFIX", "getPREFIX$annotations", "getPREFIX", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        @JvmStatic
        public static /* synthetic */ void getPREFIX$annotations() {
        }

        @NotNull
        public final String getPREFIX() {
            return PREFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

