/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.Tls;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.PropertiesUtil;
import ai.digital.integration.server.util.SslUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/tasks/TlsApplicationConfigurationOverrideTask;", "Lorg/gradle/api/DefaultTask;", "()V", "run", "", "updateDeployitConf", "tls", "Lai/digital/integration/server/domain/Tls;", "updateWrapperConf", "Companion", "integration-server-gradle-plugin"})
public class TlsApplicationConfigurationOverrideTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Tls tls = SslUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        this.updateDeployitConf(tls);
        this.updateWrapperConf(tls);
    }

    private final void updateDeployitConf(Tls tls) {
        File deployitConf;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Configurations TLS overriding for deployit.conf.");
        Project project2 = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = deployitConf = project2.file((Object)stringBuilder.append(tls2.confWorkDir()).append("/deployit.conf").toString());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"deployitConf");
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(file);
        ((Map)properties).put("ssl", String.valueOf(true));
        ((Map)properties).put("keystore.type", "pkcs12");
        ((Map)properties).put("keystore.password", tls.getKeyStorePassword());
        if (Intrinsics.areEqual((Object)"pkcs12", (Object)"pkcs12") ^ true) {
            ((Map)properties).put("keystore.keypassword", tls.getKeyPassword());
        }
        ((Map)properties).put("keystore.path", tls.keyStoreFile().getAbsolutePath());
        PropertiesUtil.Companion.writePropertiesFile(deployitConf, properties);
    }

    private final void updateWrapperConf(Tls tls) {
        File wrapperConf;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Configurations TLS overriding for xld-wrapper.conf.common.");
        Project project2 = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = wrapperConf = project2.file((Object)stringBuilder.append(tls2.confWorkDir().toString()).append("/deployit.conf").toString());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"wrapperConf");
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(file);
        for (int pos = 0; pos < 20 && properties.containsKey("wrapper.java.additional." + pos); ++pos) {
        }
        PropertiesUtil.Companion.writePropertiesFile(wrapperConf, properties);
    }

    public TlsApplicationConfigurationOverrideTask() {
        this.setGroup("Integration Server");
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)1.INSTANCE));
    }

    static {
        Companion = new Companion(null);
        NAME = "tlsApplicationConfigurationOverride";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/TlsApplicationConfigurationOverrideTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

