/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks.satellite;

import ai.digital.integration.server.domain.Satellite;
import ai.digital.integration.server.tasks.TlsApplicationConfigurationOverrideTask;
import ai.digital.integration.server.tasks.satellite.DownloadAndExtractSatelliteDistTask;
import ai.digital.integration.server.tasks.satellite.PrepareSatellitesTask;
import ai.digital.integration.server.tasks.satellite.SatelliteOverlaysTask;
import ai.digital.integration.server.tasks.satellite.SatelliteSyncPluginsTask;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.EnvironmentUtil;
import ai.digital.integration.server.util.ProcessUtil;
import ai.digital.integration.server.util.SatelliteUtil;
import ai.digital.integration.server.util.WaitForBootUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/tasks/satellite/StartSatelliteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public abstract class StartSatelliteTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file;
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            File binDir = SatelliteUtil.Companion.getBinDir(project2, satellite);
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            project3.getLogger().lifecycle("Launching Satellite '" + satellite.getName() + " from " + binDir + "'.");
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project4, "JDK_JAVA_OPTIONS", satellite.getDebugSuspend(), satellite.getDebugPort(), "xl-satellite.log");
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
            project5.getLogger().info("Starting worker with environment: " + environment);
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
            pairArray[1] = TuplesKt.to((Object)"environment", environment);
            pairArray[2] = TuplesKt.to((Object)"workDir", (Object)binDir);
            CharSequence charSequence = satellite.getStdoutFileName();
            boolean bl2 = false;
            boolean bl3 = false;
            pairArray[3] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
            charSequence = satellite.getStdoutFileName();
            bl2 = false;
            bl3 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = new StringBuilder();
                Project project6 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
                file = new File(stringBuilder.append(SatelliteUtil.Companion.getSatelliteLogDir(project6, satellite)).append('/').append(satellite.getStdoutFileName()).toString());
            } else {
                file = null;
            }
            pairArray[4] = TuplesKt.to((Object)"redirectTo", (Object)file);
            Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
            Project project7 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
            project7.getLogger().lifecycle("Satellite '" + satellite.getName() + "' successfully started on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            Project project8 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
            String string = "Satellite " + satellite.getName();
            Project project9 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"project");
            WaitForBootUtil.Companion.byLog(project8, string, SatelliteUtil.Companion.getSatelliteLog(project9, satellite), "XL Satellite has started", process);
        }
    }

    public StartSatelliteTask() {
        this.setGroup("Integration Server");
        this.dependsOn(new Object[]{DownloadAndExtractSatelliteDistTask.Companion.getNAME()});
        this.dependsOn(new Object[]{PrepareSatellitesTask.Companion.getNAME()});
        this.dependsOn(new Object[]{SatelliteOverlaysTask.Companion.getNAME()});
        this.dependsOn(new Object[]{SatelliteSyncPluginsTask.Companion.getNAME()});
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isTls(project)) {
            this.dependsOn(new Object[]{TlsApplicationConfigurationOverrideTask.Companion.getNAME()});
        }
    }

    static {
        Companion = new Companion(null);
        NAME = "startSatellite";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/satellite/StartSatelliteTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

