/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import ai.digital.integration.server.IntegrationServerExtension;
import ai.digital.integration.server.domain.Database;
import ai.digital.integration.server.domain.DbParameters;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DockerComposeUtil;
import ai.digital.integration.server.util.HTTPUtil;
import ai.digital.integration.server.util.PropertyUtil;
import ai.digital.integration.server.util.YamlFileUtil;
import com.fasterxml.jackson.core.TreeNode;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/DbUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DbUtil {
    @NotNull
    private static final String POSTGRES;
    @NotNull
    private static final String POSTGRES12;
    @NotNull
    private static final String ORACLE19;
    @NotNull
    private static final String MYSQL;
    @NotNull
    private static final String MYSQL8;
    @NotNull
    private static final String MSSQL;
    @NotNull
    private static final String DERBY;
    @NotNull
    private static final String DERBY_NETWORK;
    @NotNull
    private static final String DERBY_INMEMORY;
    private static final int randomDerbyPort;
    private static final DbParameters postgresParams;
    private static final DbParameters mysqlParams;
    private static final DbParameters oracle19Params;
    private static final DbParameters mssqlParams;
    private static final DbParameters derbyParams;
    private static final DbParameters derbyNetworkParams;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        POSTGRES = "postgres-10";
        POSTGRES12 = "postgres-12";
        ORACLE19 = "oracle-19c-se";
        MYSQL = "mysql";
        MYSQL8 = "mysql-8";
        MSSQL = "mssql";
        DERBY = "derby";
        DERBY_NETWORK = "derby-network";
        DERBY_INMEMORY = "derby-inmemory";
        randomDerbyPort = HTTPUtil.Companion.findFreePort();
        postgresParams = new DbParameters("org.postgresql:postgresql", "org.postgresql.Driver", "org.dbunit.ext.postgresql.PostgresqlDataTypeFactory", null, "\"?\"");
        mysqlParams = new DbParameters("mysql:mysql-connector-java", "com.mysql.jdbc.Driver", "org.dbunit.ext.mysql.MySqlDataTypeFactory", "org.dbunit.ext.mysql.MySqlMetadataHandler", "`?`");
        oracle19Params = new DbParameters("com.oracle.database.jdbc:ojdbc11", "oracle.jdbc.OracleDriver", "org.dbunit.ext.oracle.OracleDataTypeFactory", null, "\"?\"");
        mssqlParams = new DbParameters("com.microsoft.sqlserver:mssql-jdbc", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.dbunit.ext.mssql.MsSqlDataTypeFactory", null, "\"?\"");
        derbyParams = new DbParameters("org.apache.derby:derby", null, null, null, "\"?\"");
        derbyNetworkParams = new DbParameters("org.apache.derby:derbyclient", null, null, null, "\"?\"");
    }

    @NotNull
    public static final String getPOSTGRES() {
        Companion companion = Companion;
        return POSTGRES;
    }

    @NotNull
    public static final String getPOSTGRES12() {
        Companion companion = Companion;
        return POSTGRES12;
    }

    @NotNull
    public static final String getORACLE19() {
        Companion companion = Companion;
        return ORACLE19;
    }

    @NotNull
    public static final String getMYSQL() {
        Companion companion = Companion;
        return MYSQL;
    }

    @NotNull
    public static final String getMYSQL8() {
        Companion companion = Companion;
        return MYSQL8;
    }

    @NotNull
    public static final String getMSSQL() {
        Companion companion = Companion;
        return MSSQL;
    }

    @NotNull
    public static final String getDERBY() {
        Companion companion = Companion;
        return DERBY;
    }

    @NotNull
    public static final String getDERBY_NETWORK() {
        Companion companion = Companion;
        return DERBY_NETWORK;
    }

    @NotNull
    public static final String getDERBY_INMEMORY() {
        Companion companion = Companion;
        return DERBY_INMEMORY;
    }

    @JvmStatic
    @NotNull
    public static final String databaseName(@NotNull Project project) {
        return Companion.databaseName(project);
    }

    @JvmStatic
    @Nullable
    public static final InputStream dbConfigStream(@NotNull Project project) {
        return Companion.dbConfigStream(project);
    }

    @JvmStatic
    public static final boolean isDerby(@NotNull Project project) {
        return Companion.isDerby(project);
    }

    @JvmStatic
    public static final boolean isDerby(@NotNull String name) {
        return Companion.isDerby(name);
    }

    @JvmStatic
    public static final boolean isDerbyNetwork(@NotNull Project project) {
        return Companion.isDerbyNetwork(project);
    }

    @JvmStatic
    public static final void assertNotDerby(@NotNull Project project, @NotNull String message) {
        Companion.assertNotDerby(project, message);
    }

    @JvmStatic
    @Nullable
    public static final TreeNode dbConfig(@NotNull Project project) {
        return Companion.dbConfig(project);
    }

    @JvmStatic
    private static final Database enrichDatabase(Project project, Database database) {
        return DbUtil.Companion.enrichDatabase(project, database);
    }

    @JvmStatic
    @NotNull
    public static final Database getDatabase(@NotNull Project project) {
        return Companion.getDatabase(project);
    }

    @JvmStatic
    @NotNull
    public static final Path getResolveDbFilePath(@NotNull Project project) {
        return Companion.getResolveDbFilePath(project);
    }

    @JvmStatic
    @NotNull
    public static final String dockerComposeFileName(@NotNull Project project) {
        return Companion.dockerComposeFileName(project);
    }

    @JvmStatic
    @NotNull
    public static final DbParameters detectDbDependencies(@NotNull String db) {
        return Companion.detectDbDependencies(db);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0004H\u0007J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0007J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010+\u001a\u00020,H\u0007J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u0004H\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,H\u0007J\u0018\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020,2\u0006\u00108\u001a\u000207H\u0003J\u0010\u00109\u001a\u0002072\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010:\u001a\u00020;2\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u0004H\u0007J\u0010\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010?\u001a\u00020=2\u0006\u0010+\u001a\u00020,H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R\u001c\u0010\u0011\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0007R\u001c\u0010\u0014\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0007R\u001c\u0010\u0017\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0007R\u001c\u0010\u001a\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0007R\u001c\u0010\u001d\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0007R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lai/digital/integration/server/util/DbUtil$Companion;", "", "()V", "DERBY", "", "getDERBY$annotations", "getDERBY", "()Ljava/lang/String;", "DERBY_INMEMORY", "getDERBY_INMEMORY$annotations", "getDERBY_INMEMORY", "DERBY_NETWORK", "getDERBY_NETWORK$annotations", "getDERBY_NETWORK", "MSSQL", "getMSSQL$annotations", "getMSSQL", "MYSQL", "getMYSQL$annotations", "getMYSQL", "MYSQL8", "getMYSQL8$annotations", "getMYSQL8", "ORACLE19", "getORACLE19$annotations", "getORACLE19", "POSTGRES", "getPOSTGRES$annotations", "getPOSTGRES", "POSTGRES12", "getPOSTGRES12$annotations", "getPOSTGRES12", "derbyNetworkParams", "Lai/digital/integration/server/domain/DbParameters;", "derbyParams", "mssqlParams", "mysqlParams", "oracle19Params", "postgresParams", "randomDerbyPort", "", "assertNotDerby", "", "project", "Lorg/gradle/api/Project;", "message", "databaseName", "dbConfig", "Lcom/fasterxml/jackson/core/TreeNode;", "dbConfigStream", "Ljava/io/InputStream;", "detectDbDependencies", "db", "dockerComposeFileName", "enrichDatabase", "Lai/digital/integration/server/domain/Database;", "database", "getDatabase", "getResolveDbFilePath", "Ljava/nio/file/Path;", "isDerby", "", "name", "isDerbyNetwork", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getPOSTGRES$annotations() {
        }

        @NotNull
        public final String getPOSTGRES() {
            return POSTGRES;
        }

        @JvmStatic
        public static /* synthetic */ void getPOSTGRES12$annotations() {
        }

        @NotNull
        public final String getPOSTGRES12() {
            return POSTGRES12;
        }

        @JvmStatic
        public static /* synthetic */ void getORACLE19$annotations() {
        }

        @NotNull
        public final String getORACLE19() {
            return ORACLE19;
        }

        @JvmStatic
        public static /* synthetic */ void getMYSQL$annotations() {
        }

        @NotNull
        public final String getMYSQL() {
            return MYSQL;
        }

        @JvmStatic
        public static /* synthetic */ void getMYSQL8$annotations() {
        }

        @NotNull
        public final String getMYSQL8() {
            return MYSQL8;
        }

        @JvmStatic
        public static /* synthetic */ void getMSSQL$annotations() {
        }

        @NotNull
        public final String getMSSQL() {
            return MSSQL;
        }

        @JvmStatic
        public static /* synthetic */ void getDERBY$annotations() {
        }

        @NotNull
        public final String getDERBY() {
            return DERBY;
        }

        @JvmStatic
        public static /* synthetic */ void getDERBY_NETWORK$annotations() {
        }

        @NotNull
        public final String getDERBY_NETWORK() {
            return DERBY_NETWORK;
        }

        @JvmStatic
        public static /* synthetic */ void getDERBY_INMEMORY$annotations() {
        }

        @NotNull
        public final String getDERBY_INMEMORY() {
            return DERBY_INMEMORY;
        }

        @JvmStatic
        @NotNull
        public final String databaseName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return String.valueOf(PropertyUtil.Companion.resolveValue(project, "database", this.getDERBY_INMEMORY()));
        }

        @JvmStatic
        @Nullable
        public final InputStream dbConfigStream(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String dbname = this.databaseName(project);
            return ((Object)((Object)dbConfigStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream("database-conf/deploy-repository.yaml." + dbname);
        }

        @JvmStatic
        public final boolean isDerby(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String dbname = this.databaseName(project);
            return this.isDerby(dbname);
        }

        @JvmStatic
        public final boolean isDerby(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.areEqual((Object)name, (Object)this.getDERBY_NETWORK()) || Intrinsics.areEqual((Object)name, (Object)this.getDERBY_INMEMORY()) || Intrinsics.areEqual((Object)name, (Object)this.getDERBY());
        }

        @JvmStatic
        public final boolean isDerbyNetwork(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String dbName = this.databaseName(project);
            return Intrinsics.areEqual((Object)dbName, (Object)this.getDERBY_NETWORK()) || Intrinsics.areEqual((Object)dbName, (Object)this.getDERBY());
        }

        @JvmStatic
        public final void assertNotDerby(@NotNull Project project, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String dbname = this.databaseName(project);
            if (this.isDerby(dbname)) {
                throw (Throwable)new GradleException(message);
            }
        }

        @JvmStatic
        @Nullable
        public final TreeNode dbConfig(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            InputStream from2 = this.dbConfigStream(project);
            return from2 != null ? YamlFileUtil.Companion.readTree(from2) : null;
        }

        @JvmStatic
        private final Database enrichDatabase(Project project, Database database) {
            boolean bl;
            database.setDerbyPort(project.hasProperty("derbyPort") ? Integer.valueOf(String.valueOf(project.property("derbyPort"))) : Integer.valueOf(randomDerbyPort));
            if (project.hasProperty("logSql")) {
                String string = String.valueOf(project.property("logSql"));
                boolean bl2 = false;
                bl = Boolean.parseBoolean(string);
            } else {
                bl = database.getLogSql();
            }
            database.setLogSql(bl);
            return database;
        }

        @JvmStatic
        @NotNull
        public final Database getDatabase(@NotNull Project project) {
            Database db;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NamedDomainObjectContainer<Database> databases = ((IntegrationServerExtension)project.getExtensions().getByType(IntegrationServerExtension.class)).getDatabases();
            Database database = db = databases.isEmpty() ? new Database(this.databaseName(project)) : (Database)CollectionsKt.first((Iterable)((Iterable)databases));
            Intrinsics.checkNotNullExpressionValue((Object)database, (String)"db");
            return this.enrichDatabase(project, database);
        }

        @JvmStatic
        @NotNull
        public final Path getResolveDbFilePath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String composeFileName = this.dockerComposeFileName(project);
            return DockerComposeUtil.Companion.getResolvedDockerPath(project, "database-compose/" + composeFileName);
        }

        @JvmStatic
        @NotNull
        public final String dockerComposeFileName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String dbName = this.databaseName(project);
            return "docker-compose_" + dbName + ".yaml";
        }

        @JvmStatic
        @NotNull
        public final DbParameters detectDbDependencies(@NotNull String db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            String string = db;
            return Intrinsics.areEqual((Object)string, (Object)this.getDERBY()) ? derbyNetworkParams : (Intrinsics.areEqual((Object)string, (Object)this.getDERBY_INMEMORY()) ? derbyParams : (Intrinsics.areEqual((Object)string, (Object)this.getDERBY_NETWORK()) ? derbyNetworkParams : (Intrinsics.areEqual((Object)string, (Object)this.getMSSQL()) ? mssqlParams : (Intrinsics.areEqual((Object)string, (Object)this.getMYSQL()) || Intrinsics.areEqual((Object)string, (Object)this.getMYSQL8()) ? mysqlParams : (Intrinsics.areEqual((Object)string, (Object)this.getORACLE19()) ? oracle19Params : (Intrinsics.areEqual((Object)string, (Object)this.getPOSTGRES()) || Intrinsics.areEqual((Object)string, (Object)this.getPOSTGRES12()) ? postgresParams : derbyNetworkParams))))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

