/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.domain.Test;
import ai.digital.integration.server.util.CliUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.FileUtil;
import ai.digital.integration.server.util.TestUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/tasks/IntegrationTestsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "executeScripts", "", "server", "Lai/digital/integration/server/domain/Server;", "tests", "", "Lai/digital/integration/server/domain/Test;", "launch", "Companion", "integration-server-gradle-plugin"})
public abstract class IntegrationTestsTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    private final void executeScripts(Server server, List<? extends Test> tests) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Executing test scripts ....");
        Iterable $this$forEach$iv = tests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file;
            Test test = (Test)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            project2.getLogger().lifecycle("About to execute test `" + test.getName() + "` ...");
            boolean bl2 = false;
            List filesToExecute = new ArrayList();
            boolean bl3 = false;
            List filesForTeardown = new ArrayList();
            if (test.getBaseDirectory() == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            File dir = file;
            boolean bl6 = false;
            String basedir = dir.getAbsolutePath();
            Iterable $this$forEach$iv2 = test.getSetupScripts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String setupScript = (String)element$iv2;
                boolean bl7 = false;
                String string = basedir;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"basedir");
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(string, '/' + setupScript + '$'));
            }
            String string = basedir;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"basedir");
            filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(string, test.getScriptPattern(), test.getExcludesPattern()));
            $this$forEach$iv2 = test.getTearDownScripts();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String teardownScript = (String)element$iv2;
                boolean bl8 = false;
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(basedir, '/' + teardownScript + '$'));
                filesForTeardown.addAll((Collection)FileUtil.Companion.findFiles(basedir, '/' + teardownScript + '$'));
            }
            try {
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
                CliUtil.Companion.executeScripts(project3, filesToExecute, "test", server.getTls(), test);
            }
            catch (Exception ignored) {
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                CliUtil.Companion.executeScripts(project4, filesForTeardown, "teardown", server.getTls(), test);
            }
        }
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        FilesKt.deleteRecursively((File)CliUtil.Companion.getCliLogFolder(project));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project2);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        this.executeScripts(server, TestUtil.Companion.getExecutableTests(project3));
    }

    public IntegrationTestsTask() {
        this.setGroup("Integration Server");
    }

    static {
        Companion = new Companion(null);
        NAME = "integrationTests";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/IntegrationTestsTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

