/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.domain.AkkaSecured;
import ai.digital.integration.server.tasks.DownloadAndExtractServerDistTask;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.HTTPUtil;
import ai.digital.integration.server.util.MqUtil;
import ai.digital.integration.server.util.SatelliteUtil;
import ai.digital.integration.server.util.SslUtil;
import ai.digital.integration.server.util.WorkerUtil;
import ai.digital.integration.server.util.YamlFileUtil;
import com.fasterxml.jackson.core.TreeNode;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J-\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lai/digital/integration/server/tasks/CentralConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "()V", "createCentralConfigurationFiles", "", "launch", "mq", "", "", "mqName", "mqPort", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/Map;", "overlayRepositoryConfig", "serverDir", "taskConfig", "", "project", "Lorg/gradle/api/Project;", "Companion", "integration-server-gradle-plugin"})
public abstract class CentralConfigurationTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    private final void overlayRepositoryConfig(String serverDir) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Creating custom deploy-repository.yaml");
        File deployRepositoryYaml = new File(serverDir + "/centralConfiguration/deploy-repository.yaml");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        TreeNode treeNode = DbUtil.Companion.dbConfig(project2);
        if (treeNode != null) {
            TreeNode treeNode2 = treeNode;
            boolean bl = false;
            boolean bl2 = false;
            TreeNode config = treeNode2;
            boolean bl3 = false;
            YamlFileUtil.Companion.writeFileValue(deployRepositoryYaml, config);
        }
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        if (DbUtil.Companion.isDerbyNetwork(project3)) {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            String port = String.valueOf(DbUtil.Companion.getDatabase(project4).getDerbyPort());
            String dbUrl = "jdbc:derby://localhost:" + port + "/xldrepo;create=true;user=admin;password=admin";
            YamlFileUtil.Companion.overlayFile(deployRepositoryYaml, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"xl.repository.database.db-url", (Object)dbUrl)}));
        }
    }

    private final void createCentralConfigurationFiles() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("Generating initial central configuration files");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String serverDir = DeployServerUtil.Companion.getServerWorkingDir(project2);
        this.overlayRepositoryConfig(serverDir);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        project3.getLogger().lifecycle("Creating custom deploy-server.yaml");
        Map serverYaml = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.server.port", (Object)HTTPUtil.Companion.findFreePort()), TuplesKt.to((Object)"deploy.server.hostname", (Object)"127.0.0.1")});
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        if (DeployServerUtil.Companion.isAkkaSecured(project4)) {
            AkkaSecured secured;
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
            Project project6 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
            AkkaSecured akkaSecured = secured = SslUtil.Companion.getAkkaSecured(project5, DeployServerUtil.Companion.getServerWorkingDir(project6));
            if (akkaSecured != null) {
                AkkaSecured akkaSecured2 = akkaSecured;
                boolean bl = false;
                boolean bl2 = false;
                AkkaSecured sec = akkaSecured2;
                boolean bl3 = false;
                Map<String, AkkaSecured.KeyMeta> map = sec.getKeys();
                StringBuilder stringBuilder = new StringBuilder().append("akka_ssl_master_");
                Project project7 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
                AkkaSecured.KeyMeta key = map.get(stringBuilder.append(DeployServerUtil.Companion.getServer(project7).getName()).toString());
                if (key != null) {
                    serverYaml.putAll(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.server.ssl.enabled", (Object)true), TuplesKt.to((Object)"deploy.server.ssl.key-store", (Object)key.keyStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.key-store-password", (Object)key.getKeyStorePassword()), TuplesKt.to((Object)"deploy.server.ssl.trust-store", (Object)sec.trustStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.trust-store-password", (Object)sec.getTruststorePassword())}));
                    if (Intrinsics.areEqual((Object)"jks", (Object)"pkcs12") ^ true) {
                        serverYaml.put("deploy.server.ssl.key-password", key.getKeyPassword());
                    }
                }
            }
        }
        YamlFileUtil.Companion.overlayFile(new File(serverDir + "/centralConfiguration/deploy-server.yaml"), serverYaml);
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
        project8.getLogger().lifecycle("Creating custom deploy-task.yaml");
        File file = new File(serverDir + "/centralConfiguration/deploy-task.yaml");
        Project project9 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"project");
        YamlFileUtil.Companion.overlayFile(file, this.taskConfig(project9));
        Project project10 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project10, (String)"project");
        if (SatelliteUtil.Companion.hasSatellites(project10)) {
            Project project11 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project11, (String)"project");
            project11.getLogger().lifecycle("Creating custom deploy-satellite.yaml");
            YamlFileUtil.Companion.overlayFile(new File(serverDir + "/centralConfiguration/deploy-satellite.yaml"), MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.satellite.enabled", (Object)true)}));
        }
    }

    private final Map<String, Object> taskConfig(Project project) {
        Map<String, String> mqDetail = this.mq(MqUtil.Companion.mqName(project), MqUtil.Companion.mqPort(project));
        Map config = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.queue.name", (Object)"xld-tasks-queue"), TuplesKt.to((Object)"deploy.task.queue.archive-queue-name", (Object)"xld-archive-queue")});
        config.putAll(WorkerUtil.Companion.hasWorkers(project) ? MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"false"), TuplesKt.to((Object)"deploy.task.queue.external.jms-driver-classname", (Object)String.valueOf(mqDetail.get("jms-driver-classname"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-password", (Object)String.valueOf(mqDetail.get("jms-password"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-url", (Object)String.valueOf(mqDetail.get("jms-url"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-username", (Object)String.valueOf(mqDetail.get("jms-username"))), TuplesKt.to((Object)"akka.io.dns.resolver", (Object)"inet-address")}) : MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"true")}));
        return config;
    }

    private final Map<String, String> mq(String mqName, Integer mqPort) {
        boolean hasPort = mqPort != null && mqPort > 0;
        Map rabbitMq = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"com.rabbitmq.jms.admin.RMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"guest"), TuplesKt.to((Object)"jms-url", (Object)("amqp://localhost:" + (hasPort ? mqPort : "5672"))), TuplesKt.to((Object)"jms-username", (Object)"guest")});
        Map activeMq = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"org.apache.activemq.ActiveMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"admin"), TuplesKt.to((Object)"jms-url", (Object)("tcp://localhost:" + (hasPort ? mqPort : "61616"))), TuplesKt.to((Object)"jms-username", (Object)"admin")});
        return Intrinsics.areEqual((Object)"activemq", (Object)mqName) ? activeMq : rabbitMq;
    }

    @TaskAction
    public final void launch() {
        this.createCentralConfigurationFiles();
    }

    public CentralConfigurationTask() {
        this.dependsOn(new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()});
        this.setGroup("Integration Server");
    }

    static {
        Companion = new Companion(null);
        NAME = "centralConfiguration";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/CentralConfigurationTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

