/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks.database;

import ai.digital.integration.server.tasks.ApplicationConfigurationOverrideTask;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.FileUtil;
import com.palantir.gradle.docker.DockerComposeUp;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/tasks/database/DatabaseStartTask;", "Lcom/palantir/gradle/docker/DockerComposeUp;", "()V", "getDescription", "", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public abstract class DatabaseStartTask
extends DockerComposeUp {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder().append("Starts database instance using `docker-compose` and ");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return stringBuilder.append(DbUtil.Companion.dockerComposeFileName(project)).append(" file.").toString();
    }

    @InputFiles
    @NotNull
    public File getDockerComposeFile() {
        CodeSource src;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DbUtil.Companion.assertNotDerby(project, "Docker compose tasks do not support Derby database.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Path resultComposeFilePath = DbUtil.Companion.getResolveDbFilePath(project2);
        ProtectionDomain protectionDomain = DatabaseStartTask.class.getProtectionDomain();
        Intrinsics.checkNotNullExpressionValue((Object)protectionDomain, (String)"DatabaseStartTask::class.java.protectionDomain");
        CodeSource codeSource = src = protectionDomain.getCodeSource();
        if (codeSource != null) {
            CodeSource codeSource2 = codeSource;
            boolean bl = false;
            boolean bl2 = false;
            CodeSource codeSource3 = codeSource2;
            boolean bl3 = false;
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            String dbName = DbUtil.Companion.databaseName(project3);
            String string = dbName + "-docker";
            File file = resultComposeFilePath.getParent().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resultComposeFilePath.parent.toFile()");
            new File(string, file.getPath()).mkdirs();
            URL jar = codeSource3.getLocation();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while (true) {
                String dockerFileName;
                ZipEntry entry;
                if ((entry = zip.getNextEntry()) == null) {
                    continue;
                }
                String name = entry.getName();
                String folderName = "database-compose/" + dbName + "-docker/";
                String string2 = name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                if (!StringsKt.startsWith$default((String)string2, (String)folderName, (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)name, (Object)folderName) ^ true)) continue;
                String string3 = name;
                int n = StringsKt.indexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                InputStream inputStream = zip;
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                FileUtil.Companion.copyFile(inputStream, DeployServerUtil.Companion.getRelativePathInIntegrationServerDist(project4, dockerFileName));
            }
        }
        File file = this.getProject().file((Object)resultComposeFilePath);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(resultComposeFilePath)");
        return file;
    }

    @TaskAction
    public void run() {
        super.run();
    }

    public DatabaseStartTask() {
        this.setGroup("Integration Server");
        this.mustRunAfter(new Object[]{ApplicationConfigurationOverrideTask.Companion.getNAME()});
    }

    static {
        Companion = new Companion(null);
        NAME = "databaseStart";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/database/DatabaseStartTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

