/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks.mq;

import ai.digital.integration.server.util.MqUtil;
import ai.digital.integration.server.util.WorkerUtil;
import com.palantir.gradle.docker.DockerComposeUp;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/tasks/mq/StartMqTask;", "Lcom/palantir/gradle/docker/DockerComposeUp;", "()V", "getDescription", "", "getDockerComposeFile", "Ljava/io/File;", "run", "", "Companion", "integration-server-gradle-plugin"})
public abstract class StartMqTask
extends DockerComposeUp {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder().append("Starts RabbitMQ using `docker-compose` and ");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return stringBuilder.append(MqUtil.Companion.getMqRelativePath(project)).append(" file.").toString();
    }

    @InputFiles
    @NotNull
    public File getDockerComposeFile() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = project.file((Object)MqUtil.Companion.getResolvedDockerFile(project2));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(MqUtil.getR\u2026olvedDockerFile(project))");
        return file;
    }

    @TaskAction
    public void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Logger logger = project.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Starting ");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        logger.lifecycle(stringBuilder.append(MqUtil.Companion.mqName(project2)).append(" MQ.").toString());
        this.getProject().exec((Action)new Action<ExecSpec>(this){
            final /* synthetic */ StartMqTask this$0;

            public final void execute(ExecSpec it) {
                ExecSpec execSpec = it;
                Intrinsics.checkNotNullExpressionValue((Object)execSpec, (String)"it");
                execSpec.setExecutable("docker-compose");
                Object[] objectArray = new String[6];
                objectArray[0] = "-f";
                objectArray[1] = this.this$0.getDockerComposeFile().getPath();
                objectArray[2] = "--project-directory";
                Project project = this.this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                objectArray[3] = MqUtil.Companion.getMqDirectory(project);
                objectArray[4] = "up";
                objectArray[5] = "-d";
                it.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
            }
            {
                this.this$0 = startMqTask;
            }
        });
    }

    public StartMqTask() {
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    static {
        Companion = new Companion(null);
        NAME = "startMq";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/mq/StartMqTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

