/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks;

import ai.digital.integration.server.tasks.DockerBasedStopDeployTask;
import ai.digital.integration.server.tasks.database.DatabaseStopTask;
import ai.digital.integration.server.tasks.satellite.ShutdownSatelliteTask;
import ai.digital.integration.server.tasks.worker.ShutdownWorkersTask;
import ai.digital.integration.server.util.DbUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.SatelliteUtil;
import ai.digital.integration.server.util.ShutdownUtil;
import ai.digital.integration.server.util.WorkerUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/tasks/ShutdownIntegrationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "shutdown", "", "Companion", "integration-server-gradle-plugin"})
public abstract class ShutdownIntegrationServerTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    @TaskAction
    public final void shutdown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        project.getLogger().lifecycle("About to shutting down Deploy Server.");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (!DeployServerUtil.Companion.isDockerBased(project2)) {
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            ShutdownUtil.Companion.shutdownServer(project3);
        }
    }

    public ShutdownIntegrationServerTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isDockerBased(project)) {
            this.dependsOn(new Object[]{DockerBasedStopDeployTask.Companion.getNAME()});
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project2)) {
            this.dependsOn(new Object[]{ShutdownWorkersTask.Companion.getNAME()});
        }
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        if (SatelliteUtil.Companion.hasSatellites(project3)) {
            this.dependsOn(new Object[]{ShutdownSatelliteTask.Companion.getNAME()});
        }
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        if (DbUtil.Companion.isDerby(project4)) {
            this.finalizedBy(new Object[]{"derbyStop"});
        } else {
            this.finalizedBy(new Object[]{DatabaseStopTask.Companion.getNAME()});
        }
    }

    static {
        Companion = new Companion(null);
        NAME = "shutdownIntegrationServer";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/ShutdownIntegrationServerTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

