/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import ai.digital.integration.server.IntegrationServerExtension;
import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.util.ConfigurationsUtil;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.DockerComposeUtil;
import ai.digital.integration.server.util.FileUtil;
import ai.digital.integration.server.util.IntegrationServerUtil;
import ai.digital.integration.server.util.JavaUtil;
import ai.digital.integration.server.util.PropertiesUtil;
import ai.digital.integration.server.util.PropertyUtil;
import ai.digital.integration.server.util.WaitForBootUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/DeployServerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final String getHttpHost() {
        return Companion.getHttpHost();
    }

    @JvmStatic
    @NotNull
    public static final String getUrl(@NotNull Project project) {
        return Companion.getUrl(project);
    }

    @JvmStatic
    @NotNull
    public static final String composeUrl(@NotNull Project project, @NotNull String path) {
        return Companion.composeUrl(project, path);
    }

    @JvmStatic
    public static final boolean isTls(@NotNull Project project) {
        return Companion.isTls(project);
    }

    @JvmStatic
    public static final boolean isAkkaSecured(@NotNull Project project) {
        return Companion.isAkkaSecured(project);
    }

    @JvmStatic
    @NotNull
    public static final Server getServer(@NotNull Project project) {
        return Companion.getServer(project);
    }

    @JvmStatic
    @NotNull
    public static final String getServerWorkingDir(@NotNull Project project) {
        return Companion.getServerWorkingDir(project);
    }

    @JvmStatic
    @NotNull
    public static final Path getRelativePathInIntegrationServerDist(@NotNull Project project, @NotNull String relativePath) {
        return Companion.getRelativePathInIntegrationServerDist(project, relativePath);
    }

    @JvmStatic
    @NotNull
    public static final Path getServerDistFolderPath(@NotNull Project project) {
        return Companion.getServerDistFolderPath(project);
    }

    @JvmStatic
    public static final boolean isDockerBased(@NotNull Project project) {
        return Companion.isDockerBased(project);
    }

    @JvmStatic
    private static final String getServerVersion(Project project, Server server) {
        return DeployServerUtil.Companion.getServerVersion(project, server);
    }

    @JvmStatic
    private static final int getHttpPort(Project project, Server server) {
        return DeployServerUtil.Companion.getHttpPort(project, server);
    }

    @JvmStatic
    private static final Integer getDebugPort(Project project, Server server) {
        return DeployServerUtil.Companion.getDebugPort(project, server);
    }

    @JvmStatic
    @NotNull
    public static final String createDebugString(boolean debugSuspend, int debugPort) {
        return Companion.createDebugString(debugSuspend, debugPort);
    }

    @JvmStatic
    public static final boolean isServerDefined(@NotNull Project project) {
        return Companion.isServerDefined(project);
    }

    @JvmStatic
    public static final boolean isDistDownloadRequired(@NotNull Project project) {
        return Companion.isDistDownloadRequired(project);
    }

    @JvmStatic
    @NotNull
    public static final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
        return Companion.readDeployitConfProperty(project, key);
    }

    @JvmStatic
    @NotNull
    public static final File getLogDir(@NotNull Project project) {
        return Companion.getLogDir(project);
    }

    @JvmStatic
    public static final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
        Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    @JvmStatic
    public static final void waitForBoot(@NotNull Project project, @Nullable Process process) {
        Companion.waitForBoot(project, process);
    }

    @JvmStatic
    @NotNull
    public static final Process startServerFromClasspath(@NotNull Project project) {
        return Companion.startServerFromClasspath(project);
    }

    @JvmStatic
    @NotNull
    public static final String getDockerImageVersion(@NotNull Project project) {
        return Companion.getDockerImageVersion(project);
    }

    @JvmStatic
    @NotNull
    public static final String getDockerServiceName(@NotNull Project project) {
        return Companion.getDockerServiceName(project);
    }

    @JvmStatic
    @NotNull
    public static final Path getResolvedDockerFile(@NotNull Project project) {
        return Companion.getResolvedDockerFile(project);
    }

    @JvmStatic
    private static final String dockerServerRelativePath() {
        return DeployServerUtil.Companion.dockerServerRelativePath();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0004H\u0003J\u001f\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0004H\u0007J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010,\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010-\u001a\u0004\u0018\u00010+H\u0007\u00a8\u0006."}, d2={"Lai/digital/integration/server/util/DeployServerUtil$Companion;", "", "()V", "composeUrl", "", "project", "Lorg/gradle/api/Project;", "path", "createDebugString", "debugSuspend", "", "debugPort", "", "dockerServerRelativePath", "getDebugPort", "server", "Lai/digital/integration/server/domain/Server;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/domain/Server;)Ljava/lang/Integer;", "getDockerImageVersion", "getDockerServiceName", "getHttpHost", "getHttpPort", "getLogDir", "Ljava/io/File;", "getRelativePathInIntegrationServerDist", "Ljava/nio/file/Path;", "relativePath", "getResolvedDockerFile", "getServer", "getServerDistFolderPath", "getServerVersion", "getServerWorkingDir", "getUrl", "grantPermissionsToIntegrationServerFolder", "", "isAkkaSecured", "isDistDownloadRequired", "isDockerBased", "isServerDefined", "isTls", "readDeployitConfProperty", "key", "startServerFromClasspath", "Ljava/lang/Process;", "waitForBoot", "process", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getHttpHost() {
            return "localhost";
        }

        @JvmStatic
        @NotNull
        public final String getUrl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            String hostName = this.getHttpHost();
            return this.isTls(project) ? "https://" + hostName + ':' + server.getHttpPort() + server.getContextRoot() : "http://" + hostName + ':' + server.getHttpPort() + server.getContextRoot();
        }

        @JvmStatic
        @NotNull
        public final String composeUrl(@NotNull Project project, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String url = this.getUrl(project);
            String separator = "/";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                separator = "";
                if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                    url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
                }
            }
            return url + separator + path;
        }

        @JvmStatic
        public final boolean isTls(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getTls();
        }

        @JvmStatic
        public final boolean isAkkaSecured(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getAkkaSecured();
        }

        @JvmStatic
        @NotNull
        public final Server getServer(@NotNull Project project) {
            Server server;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            IntegrationServerExtension ext = (IntegrationServerExtension)project.getExtensions().getByType(IntegrationServerExtension.class);
            Server server2 = server = (Server)CollectionsKt.first((Iterable)((Iterable)ext.getServers()));
            Intrinsics.checkNotNullExpressionValue((Object)server2, (String)"server");
            server.setDebugPort(this.getDebugPort(project, server2));
            server.setHttpPort(this.getHttpPort(project, server));
            server.setVersion(this.getServerVersion(project, server));
            String string = server.getDockerImage();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                server.setRuntimeDirectory(null);
            }
            if (!StringsKt.startsWith$default((String)server.getContextRoot(), (String)"/", (boolean)false, (int)2, null)) {
                server.setContextRoot("" + '/' + server + ".contextRoot");
            }
            return server;
        }

        @JvmStatic
        @NotNull
        public final String getServerWorkingDir(@NotNull Project project) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            if (this.isDockerBased(project)) {
                Path workDir = this.getRelativePathInIntegrationServerDist(project, "deploy");
                string = ((Object)workDir.toAbsolutePath()).toString();
            } else if (server.getRuntimeDirectory() == null) {
                String targetDir = ((Object)this.getServerDistFolderPath(project)).toString();
                string = ((Object)Paths.get(targetDir, "xl-deploy-" + server.getVersion() + "-server").toAbsolutePath()).toString();
            } else {
                String string2 = project.getProjectDir().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.projectDir.toString()");
                String target = string2;
                string = ((Object)Paths.get(target, server.getRuntimeDirectory()).toAbsolutePath()).toString();
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public final Path getRelativePathInIntegrationServerDist(@NotNull Project project, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project) + '/' + relativePath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(\"${Integration\u2026oject)}/${relativePath}\")");
            return path;
        }

        @JvmStatic
        @NotNull
        public final Path getServerDistFolderPath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(IntegrationServerUtil.getDist(project))");
            return path;
        }

        @JvmStatic
        public final boolean isDockerBased(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            CharSequence charSequence = this.getServer(project).getDockerImage();
            boolean bl = false;
            boolean bl2 = false;
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        }

        @JvmStatic
        private final String getServerVersion(Project project, Server server) {
            return project.hasProperty("xlDeployVersion") ? String.valueOf(project.property("xlDeployVersion")) : server.getVersion();
        }

        @JvmStatic
        private final int getHttpPort(Project project, Server server) {
            int n;
            if (project.hasProperty("serverHttpPort")) {
                Integer n2 = Integer.valueOf(String.valueOf(project.property("serverHttpPort")));
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"Integer.valueOf(project.\u2026verHttpPort\").toString())");
                n = n2;
            } else {
                n = server.getHttpPort();
            }
            return n;
        }

        @JvmStatic
        private final Integer getDebugPort(Project project, Server server) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "serverDebugPort", server.getDebugPort()) : null;
        }

        @JvmStatic
        @NotNull
        public final String createDebugString(boolean debugSuspend, int debugPort) {
            String suspend = debugSuspend ? "y" : "n";
            return "-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort;
        }

        @JvmStatic
        public final boolean isServerDefined(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            IntegrationServerExtension ext = (IntegrationServerExtension)project.getExtensions().getByType(IntegrationServerExtension.class);
            return ext.getServers().size() > 0;
        }

        @JvmStatic
        public final boolean isDistDownloadRequired(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getRuntimeDirectory() == null && !this.isDockerBased(project);
        }

        @JvmStatic
        @NotNull
        public final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
            File deployitConf;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File file = deployitConf = Paths.get(this.getServerWorkingDir(project) + "/conf/deployit.conf", new String[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"deployitConf");
            return PropertiesUtil.Companion.readProperty(file, key);
        }

        @JvmStatic
        @NotNull
        public final File getLogDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            File file = Paths.get(this.getServerWorkingDir(project), "log").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(getServerWorki\u2026project), \"log\").toFile()");
            return file;
        }

        @JvmStatic
        public final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.isDockerBased(project)) {
                String workDir = IntegrationServerUtil.Companion.getDist(project);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    FileUtil.Companion.grantRWPermissions(it);
                }
            }
        }

        @JvmStatic
        public final void waitForBoot(@NotNull Project project, @Nullable Process process) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String url = this.composeUrl(project, "/deployit/metadata/type");
            WaitForBootUtil.Companion.byPort(project, "Deploy", url, process);
        }

        @JvmStatic
        @NotNull
        public final Process startServerFromClasspath(@NotNull Project project) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.getLogger().lifecycle("startServerFromClasspath.");
            Server server = this.getServer(project);
            FileCollection fileCollection = project.getConfigurations().getByName(ConfigurationsUtil.Companion.getDEPLOY_SERVER()).filter((Spec)startServerFromClasspath.classpath.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.configurations.g\u2026ndsWith(\"-sources.jar\") }");
            String classpath2 = fileCollection.getAsPath();
            project.getLogger().lifecycle("Launching Deploy Server from classpath " + classpath2 + '.');
            boolean bl3 = false;
            List jvmArgs = new ArrayList();
            CollectionsKt.addAll((Collection)jvmArgs, (Object[])server.getJvmArgs());
            Integer n = server.getDebugPort();
            if (n != null) {
                Integer n2 = n;
                boolean bl4 = false;
                bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl5 = false;
                jvmArgs.addAll((Collection)JavaUtil.Companion.debugJvmArg(project, it, server.getDebugSuspend()));
            }
            Map config = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"classpath", (Object)classpath2), TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0)), TuplesKt.to((Object)"jvmArgs", (Object)jvmArgs), TuplesKt.to((Object)"mainClass", (Object)"com.xebialabs.deployit.DeployitBootstrapper"), TuplesKt.to((Object)"programArgs", (Object)CollectionsKt.listOf((Object)"-force-upgrades")), TuplesKt.to((Object)"workDir", (Object)new File(this.getServerWorkingDir(project)))});
            String string = server.getStdoutFileName();
            if (string != null) {
                String string2 = string;
                bl2 = false;
                bl = false;
                String it = string2;
                boolean bl6 = false;
                config.put("redirectTo", new File(Companion.getLogDir(project) + '/' + it));
            }
            Object v = project.getProperties().get("integrationServerJVMPath");
            if (v != null) {
                Object v2 = v;
                bl2 = false;
                bl = false;
                Object it = v2;
                boolean bl7 = false;
                Object v3 = it;
                if (v3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                config.putAll(JavaUtil.Companion.jvmPath(project, (String)v3));
            }
            project.getLogger().lifecycle("Starting integration test server on port " + server.getHttpPort() + " from runtime dir " + server.getRuntimeDirectory());
            Process process = JavaUtil.Companion.execJava(config);
            project.getLogger().lifecycle("Launched server on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            return process;
        }

        @JvmStatic
        @NotNull
        public final String getDockerImageVersion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            return server.getDockerImage() + ':' + server.getVersion();
        }

        @JvmStatic
        @NotNull
        public final String getDockerServiceName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            return "deploy-" + server.getVersion();
        }

        @JvmStatic
        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            File serverTemplate;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.dockerServerRelativePath());
            File file = serverTemplate = resultComposeFilePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"serverTemplate");
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)file, (Charset)Charsets.UTF_8), (String)"DEPLOY_SERVER_HTTP_PORT", (String)String.valueOf(server.getHttpPort()), (boolean)false, (int)4, null), (String)"DEPLOY_IMAGE_VERSION", (String)this.getDockerImageVersion(project), (boolean)false, (int)4, null), (String)"DEPLOY_PLUGINS_TO_EXCLUDE", (String)CollectionsKt.joinToString$default((Iterable)server.getDefaultOfficialPluginsToExclude(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null), (String)"DEPLOY_VERSION", (String)String.valueOf(server.getVersion()), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        @JvmStatic
        private final String dockerServerRelativePath() {
            return "deploy/server-docker-compose.yaml";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

