/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.util;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.HTTPUtil;
import groovyx.net.http.HTTPBuilder;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/util/WaitForBootUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class WaitForBootUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url) {
        Companion.byPort(project, name, url);
    }

    @JvmStatic
    public static final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url, @Nullable Process process) {
        Companion.byPort(project, name, url, process);
    }

    @JvmStatic
    public static final void byLog(@NotNull Project project, @NotNull String name, @NotNull File logFile, @NotNull String containsLine, @Nullable Process process) {
        Companion.byLog(project, name, logFile, containsLine, process);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0007J*\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/util/WaitForBootUtil$Companion;", "", "()V", "byLog", "", "project", "Lorg/gradle/api/Project;", "name", "", "logFile", "Ljava/io/File;", "containsLine", "process", "Ljava/lang/Process;", "byPort", "url", "waitForNext", "", "server", "Lai/digital/integration/server/domain/Server;", "triesLeft", "success", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.byPort(project, name, url, null);
        }

        private final int waitForNext(Project project, Process process, Server server, int triesLeft, boolean success) {
            if (!success) {
                project.getLogger().lifecycle("Retrying after " + String.valueOf(server.getPingRetrySleepTime()) + " second(s). (" + String.valueOf(triesLeft) + ")");
                if (process != null) {
                    if (process.waitFor(server.getPingRetrySleepTime(), TimeUnit.SECONDS)) {
                        return -1;
                    }
                } else {
                    TimeUnit.SECONDS.sleep(server.getPingRetrySleepTime());
                }
            }
            return triesLeft - 1;
        }

        @JvmStatic
        public final void byPort(@NotNull Project project, @NotNull String name, @NotNull String url, @Nullable Process process) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            project.getLogger().lifecycle("Waiting for " + name + " to start on URL: " + url + '.');
            Server server = DeployServerUtil.Companion.getServer(project);
            int triesLeft = server.getPingTotalTries();
            boolean success = false;
            while (triesLeft > 0 && !success) {
                try {
                    HTTPBuilder http = HTTPUtil.Companion.buildRequest(url);
                    boolean bl = false;
                    http.get((Map)new LinkedHashMap());
                    success = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                triesLeft = this.waitForNext(project, process, server, triesLeft, success);
            }
            if (!success) {
                throw (Throwable)new GradleException(name + " failed to start.");
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void byLog(@NotNull Project project, @NotNull String name, @NotNull File logFile, @NotNull String containsLine, @Nullable Process process) {
            void success;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
            Intrinsics.checkNotNullParameter((Object)containsLine, (String)"containsLine");
            project.getLogger().lifecycle("Waiting for " + name + " to start with log: '" + containsLine + "'.");
            Server server = DeployServerUtil.Companion.getServer(project);
            int triesLeft = server.getPingTotalTries();
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            while (triesLeft > 0 && !success.element) {
                try {
                    FilesKt.forEachLine$default((File)logFile, null, (Function1)((Function1)new Function1<String, Unit>(containsLine, project, name, (Ref.BooleanRef)success){
                        final /* synthetic */ String $containsLine;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ String $name;
                        final /* synthetic */ Ref.BooleanRef $success;

                        public final void invoke(@NotNull String line) {
                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                            if (StringsKt.contains$default((CharSequence)line, (CharSequence)this.$containsLine, (boolean)false, (int)2, null)) {
                                this.$project.getLogger().lifecycle(this.$name + " successfully started.");
                                this.$success.element = true;
                            }
                        }
                        {
                            this.$containsLine = string;
                            this.$project = project;
                            this.$name = string2;
                            this.$success = booleanRef;
                            super(1);
                        }
                    }), (int)1, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                triesLeft = this.waitForNext(project, process, server, triesLeft, success.element);
            }
            if (!success.element) {
                throw (Throwable)new GradleException(name + " failed to start.");
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

