/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.tasks.pluginManager;

import ai.digital.integration.server.domain.Server;
import ai.digital.integration.server.util.DeployServerUtil;
import ai.digital.integration.server.util.EnvironmentUtil;
import ai.digital.integration.server.util.ProcessUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/tasks/pluginManager/StartPluginManagerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getBinDir", "Ljava/io/File;", "launch", "", "startPluginManager", "server", "Lai/digital/integration/server/domain/Server;", "Companion", "integration-server-gradle-plugin"})
public abstract class StartPluginManagerTask
extends DefaultTask {
    @NotNull
    private static final String NAME;
    @NotNull
    public static final Companion Companion;

    private final File getBinDir() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), "bin").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Paths.get(DeployServerUt\u2026project), \"bin\").toFile()");
        return file;
    }

    private final void startPluginManager(Server server) {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)true);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        pairArray[2] = TuplesKt.to((Object)"environment", EnvironmentUtil.Companion.getServerEnv(project, server));
        pairArray[3] = TuplesKt.to((Object)"params", (Object)new String[]{"plugin-manager-cli"});
        pairArray[4] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir());
        Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        project2.getLogger().lifecycle("Launched Plugin Manager on Deploy server " + server + ".name on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        project2.getLogger().lifecycle("Launching Plugin Manager on Deploy server " + server + ".name");
        this.startPluginManager(server);
    }

    public StartPluginManagerTask() {
        List dependencies = CollectionsKt.mutableListOf((Object[])new String[]{"startIntegrationServer"});
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isTls(project)) {
            dependencies.add("tlsApplicationConfigurationOverride");
        }
        this.dependsOn(new Object[]{dependencies});
        this.setGroup("Integration Server");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return !DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    static {
        Companion = new Companion(null);
        NAME = "startPluginManager";
    }

    @NotNull
    public static final String getNAME() {
        Companion companion = Companion;
        return NAME;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/digital/integration/server/tasks/pluginManager/StartPluginManagerTask$Companion;", "", "()V", "NAME", "", "getNAME$annotations", "getNAME", "()Ljava/lang/String;", "integration-server-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getNAME$annotations() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

