/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.gradle.documentation.restdoc.doclet.FileCatalog;
import com.xebialabs.gradle.documentation.restdoc.doclet.OverviewWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.PageTemplate;
import com.xebialabs.gradle.documentation.restdoc.doclet.Resource;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestServiceWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.StandardOption;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocEnv;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocletUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.StandardDoclet;

public class RestDoclet
extends StandardDoclet {
    private File destinationDir = new File(".");
    private boolean showJsonSupport = true;
    private String productName = "XL-Release";
    private String jsonOutputFile = "api.json";

    public Set<Doclet.Option> getSupportedOptions() {
        Set<? extends Doclet.Option> defaults = super.getSupportedOptions();
        Set<Doclet.Option> options = this.getOptions();
        Set optionNames = options.stream().map(opt -> opt.getNames().get(0)).collect(Collectors.toSet());
        Set filtered = defaults.stream().filter(opt -> Collections.disjoint(opt.getNames(), optionNames)).collect(Collectors.toSet());
        options.addAll(filtered);
        return options;
    }

    private Set<Doclet.Option> getOptions() {
        HashSet<Doclet.Option> options = new HashSet<Doclet.Option>();
        options.add(new StandardOption("-showJsonSupport", this::setShowJsonSupport));
        options.add(new StandardOption("-product", this::setProductName));
        options.add(new StandardOption("-jsonOutputFile", this::setJsonOutputFile));
        options.add(new StandardOption("-d", this::setDestinationDir));
        return options;
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        DocEnv.set(docEnv);
        List<TypeElement> apiServices = DocletUtils.findAnnotatedClasses(docEnv, "com.xebialabs.xlplatform.documentation.PublicApi");
        List<TypeElement> apiRefs = DocletUtils.findAnnotatedClasses(docEnv, "com.xebialabs.xlplatform.documentation.PublicApiRef");
        ArrayList allApiClasses = Lists.newArrayList(apiServices);
        allApiClasses.addAll(apiRefs);
        Preconditions.checkNotNull((Object)this.productName, (Object)"The productName should not be 'null', please specify '-product'");
        if (!apiServices.isEmpty()) {
            this.copyCss();
            this.writeOverview(apiServices);
            this.writeServices(apiServices);
            this.writeLinkedFiles();
        }
        this.writeJsonFile(allApiClasses);
        return true;
    }

    private void copyCss() {
        Resource.fromClasspath("restdoc/layout.css").copy(new File(this.destinationDir, "layout.css"));
        Resource.fromClasspath("restdoc/restdoc.css").copy(new File(this.destinationDir, "restdoc.css"));
        Resource.fromClasspath("restdoc/image.zip").unzip(this.destinationDir);
    }

    private void writeJsonFile(List<TypeElement> restServices) {
        File destination = new File(this.destinationDir, this.jsonOutputFile);
        try (FileWriter fileWriter = new FileWriter(destination);){
            restServices.sort(Comparator.comparing(l -> l.getSimpleName().toString()));
            fileWriter.write(DocletUtils.generateJson(restServices));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void writeOverview(List<TypeElement> restServices) {
        PrintWriter writer = this.openFile("index.html", String.format("%s REST API", this.productName));
        try {
            new OverviewWriter(writer, this.productName).write(restServices);
        }
        finally {
            RestDoclet.closeFile(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices(List<TypeElement> restServices) {
        for (TypeElement service : restServices) {
            FileCatalog.SINGLETON.add(RestDoclet.fileNameFor(service.getSimpleName().toString()));
        }
        for (TypeElement service : restServices) {
            String simpleName = service.getSimpleName().toString();
            PrintWriter writer = this.openFile(RestDoclet.fileNameFor(simpleName), simpleName);
            try {
                new RestServiceWriter(writer, service, this.showJsonSupport).writeRestService();
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLinkedFiles() {
        for (String item : FileCatalog.SINGLETON.getItems()) {
            if (!FileCatalog.isResource(item)) continue;
            PrintWriter writer = this.openFile(item, item.replace(".html", ""));
            try {
                FileCatalog.write(item, writer);
            }
            finally {
                RestDoclet.closeFile(writer);
            }
        }
        for (String item : FileCatalog.SINGLETON.getMissing()) {
            System.out.println("Missing cross reference: " + item);
        }
    }

    public static String fileNameFor(String service) {
        if (service == null) {
            return null;
        }
        return service + ".html";
    }

    public PrintWriter openFile(String fileName, String title) {
        File file = new File(this.destinationDir, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            new PageTemplate(writer).writeHeader(title);
            return writer;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Can't open " + file.getAbsolutePath() + " for writing.");
        }
    }

    public static void closeFile(PrintWriter writer) {
        new PageTemplate(writer).writeFooter();
        writer.flush();
        writer.close();
    }

    public void setDestinationDir(String destinationDir) {
        this.destinationDir = new File(destinationDir);
    }

    public void setShowJsonSupport(String showJsonSupport) {
        this.showJsonSupport = Boolean.parseBoolean(showJsonSupport);
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setJsonOutputFile(String jsonOutputFile) {
        this.jsonOutputFile = jsonOutputFile;
    }
}

