/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Strings;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.xebialabs.commons.html.HtmlWriter;
import com.xebialabs.gradle.documentation.restdoc.doclet.FileCatalog;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDoclet;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDocletUtils;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocEnv;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class RestDocWriter
extends HtmlWriter {
    private final FileCatalog fileCatalog = FileCatalog.SINGLETON;

    public RestDocWriter(PrintWriter writer) {
        super(writer);
    }

    protected String asText(List<? extends DocTree> docTreeList) {
        StringBuilder builder = new StringBuilder();
        if (!docTreeList.isEmpty()) {
            for (DocTree docTree : docTreeList) {
                if (docTree instanceof SeeTree) {
                    this.appendLink(builder, docTree);
                    continue;
                }
                if (docTree instanceof ReferenceTree) {
                    this.appendReferenceText(builder, docTree);
                    continue;
                }
                if (docTree instanceof ParamTree) {
                    ((ParamTree)docTree).getDescription().stream().filter(Objects::nonNull).forEach(p -> this.checkAndAppendLink((DocTree)p, builder));
                    continue;
                }
                if (docTree instanceof LiteralTree) {
                    builder.append(this.code(new Object[]{((LiteralTree)docTree).getBody()}));
                    continue;
                }
                if (docTree instanceof DeprecatedTree) {
                    builder.append(this.span(new Object[]{"(Deprecated)"}).cssClass("deprecated"));
                    continue;
                }
                if (docTree instanceof UnknownBlockTagTree) {
                    ((UnknownBlockTagTree)docTree).getContent().stream().filter(Objects::nonNull).forEach(p -> this.checkAndAppendLink((DocTree)p, builder));
                    continue;
                }
                if (docTree instanceof ReturnTree) {
                    ((ReturnTree)docTree).getDescription().stream().filter(Objects::nonNull).forEach(p -> this.checkAndAppendLink((DocTree)p, builder));
                    continue;
                }
                if (docTree instanceof LinkTree) {
                    builder.append(((LinkTree)docTree).getReference());
                    continue;
                }
                if (docTree instanceof TextTree) {
                    builder.append(((TextTree)docTree).getBody());
                    continue;
                }
                if (builder.length() > 0) {
                    builder.append(((TextTree)docTree).getBody());
                    continue;
                }
                builder.append("");
            }
        }
        return builder.toString();
    }

    protected void checkAndAppendLink(DocTree docTree, StringBuilder builder) {
        if (docTree.toString().contains("@link")) {
            this.appendLink(builder, docTree);
        } else {
            builder.append(docTree);
        }
    }

    protected String asText(TypeMirror typeMirror) {
        StringBuilder builder = new StringBuilder();
        builder.append(typeMirror.toString());
        String separator = " of ";
        for (TypeMirror paramType : this.getParametrizedTypes(typeMirror)) {
            builder.append(separator);
            builder.append(paramType.toString());
            separator = ", ";
        }
        return builder.toString();
    }

    private void appendReferenceText(StringBuilder builder, DocTree docTree) {
        ReferenceTree linkTree = (ReferenceTree)docTree;
        String text = linkTree.getSignature();
        builder.append(text);
    }

    private void appendLink(StringBuilder builder, DocTree docTree) {
        LinkTree linkTree = (LinkTree)docTree;
        String file = RestDoclet.fileNameFor(linkTree.getReference().getSignature());
        String text = linkTree.getReference().getSignature();
        if (Strings.isNullOrEmpty((String)text)) {
            text = "";
        }
        if (this.fileCatalog.check(file)) {
            builder.append(this.link(file, new Object[]{text}));
        } else {
            builder.append(this.bold(new Object[]{text}));
        }
    }

    public static String firstWord(String sentence) {
        return sentence.split("\\s")[0];
    }

    protected String asReference(TypeMirror typeMirror) {
        List<TypeMirror> typeMirrorList = this.getParametrizedTypes(typeMirror);
        if (typeMirrorList.isEmpty()) {
            return String.valueOf((Object)typeMirror.getKind()) + ".html";
        }
        return String.valueOf(typeMirrorList.get(0)) + "-" + typeMirror.getKind().name() + ".html";
    }

    public List<TypeMirror> getParametrizedTypes(TypeMirror typeMirror) {
        ArrayList<TypeMirror> types = new ArrayList<TypeMirror>();
        if (typeMirror instanceof DeclaredType) {
            types.addAll(((DeclaredType)typeMirror).getTypeArguments());
        }
        return types;
    }

    protected Object renderType(TypeMirror typeMirror) {
        String returnTypeText = this.asText(typeMirror);
        String externalFile = this.asReference(typeMirror);
        if (this.fileCatalog.check(externalFile)) {
            returnTypeText = this.link(externalFile, new Object[]{returnTypeText});
        }
        for (TypeMirror paramType : this.getParametrizedTypes(typeMirror)) {
            this.fileCatalog.check(this.asReference(paramType));
        }
        return returnTypeText.toString().substring(returnTypeText.toString().lastIndexOf(46) + 1);
    }

    protected List<DocTree> getDeprecatedTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> deprecatedTreeList = new ArrayList<DocTree>(docTreeList);
        return deprecatedTreeList.stream().filter(ele -> ele.getKind().equals((Object)DocTree.Kind.DEPRECATED)).collect(Collectors.toList());
    }

    protected List<DocTree> getRestDetailsTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> restDetailsDocTreeList = new ArrayList<DocTree>(docTreeList);
        return restDetailsDocTreeList.stream().filter(ele -> ele.toString().contains("@restDetails")).collect(Collectors.toList());
    }

    protected List<? extends DocTree> getPermissionTags(Element service) {
        ArrayList blockTags;
        DocCommentTree commentsTree = DocEnv.get().getDocTrees().getDocCommentTree(service);
        ArrayList arrayList = blockTags = commentsTree != null ? commentsTree.getBlockTags() : new ArrayList();
        if (blockTags.isEmpty()) {
            return blockTags;
        }
        return blockTags.stream().filter(tag -> tag.toString().contains("@permission")).collect(Collectors.toList());
    }

    protected List<DocTree> getHeadersTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> restDetailsDocTreeList = new ArrayList<DocTree>(docTreeList);
        return restDetailsDocTreeList.stream().filter(ele -> ele.toString().contains("@headers")).collect(Collectors.toList());
    }

    protected List<DocTree> getReturnTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> deprecatedTreeList = new ArrayList<DocTree>(docTreeList);
        return deprecatedTreeList.stream().filter(ele -> ele.getKind().equals((Object)DocTree.Kind.RETURN)).collect(Collectors.toList());
    }

    protected List<DocTree> getSeeTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> deprecatedTreeList = new ArrayList<DocTree>(docTreeList);
        return deprecatedTreeList.stream().filter(ele -> ele.getKind().equals((Object)DocTree.Kind.SEE)).collect(Collectors.toList());
    }

    protected List<DocTree> getParamTags(Element service) {
        List<DocTree> docTreeList = RestDocletUtils.getBlockTagsDocTree(service);
        if (docTreeList.isEmpty()) {
            return docTreeList;
        }
        ArrayList<DocTree> deprecatedTreeList = new ArrayList<DocTree>(docTreeList);
        return deprecatedTreeList.stream().filter(ele -> ele.getKind().equals((Object)DocTree.Kind.PARAM)).collect(Collectors.toList());
    }

    protected List<DocTree> getDocTree(Element element) {
        DocCommentTree docCommentTree = DocEnv.get().getDocTrees().getDocCommentTree(element);
        if (docCommentTree == null || docCommentTree.getFirstSentence() == null) {
            return Collections.emptyList();
        }
        List<DocTree> firstSentenceTree = docCommentTree.getFirstSentence();
        if (docCommentTree.getFullBody() != null) {
            firstSentenceTree.addAll(docCommentTree.getFullBody().stream().filter(dt -> DocTree.Kind.DEPRECATED.equals((Object)dt.getKind())).collect(Collectors.toList()));
        }
        return firstSentenceTree;
    }

    protected List<DocTree> getEntireComment(Element element) {
        DocCommentTree docCommentTree = DocEnv.get().getDocTrees().getDocCommentTree(element);
        if (docCommentTree == null || docCommentTree.getFullBody() == null) {
            return Collections.emptyList();
        }
        return docCommentTree.getFullBody();
    }
}

