package com.xebialabs.gradle.documentation.restdoc.doclet;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.xebialabs.gradle.plugins.restdoclet.doclet.DocEnv;

public class OverviewWriter extends RestDocWriter {

    private String productName;

    public OverviewWriter(PrintWriter writer, String productName) {
        super(writer);
        this.productName = productName;
    }

    public void write(List<TypeElement> services) {
        writeHeader();
        writePackageInfo(services);
        writeServices(services);
    }

    private void writePackageInfo(List<TypeElement> services) {
        // Collect packages
        Set<PackageElement> packages = new LinkedHashSet<>();
        for (Element service : services) {
            packages.add(DocEnv.get().getElementUtils().getPackageOf(service));
        }

        // Write packages
        for (PackageElement pack : packages) {
            DocCommentTree docCommentTree = DocEnv.get().getDocTrees().getDocCommentTree(pack);
            List<? extends DocTree> docTrees = new ArrayList<>();
            if(docCommentTree != null) docTrees = docCommentTree.getFullBody();
            p(asText(docTrees)).write();
    }
    }

    private void writeServices(List<TypeElement> services) {
        table().cssClass("services").writeOpen();

        for (Element service : services) {
            row(
                    link(RestDoclet.fileNameFor(service.getSimpleName().toString()), service.getSimpleName()),
                    asText(getDocTree(service))
            ).write();
        }

        table().writeClose();
    }

    //
    // Html rendering
    //

    public void writeHeader() {
        div(h1(String.format("%s REST API", productName))).cssClass("manual-title").write();
    }

}
