package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner;

import javax.lang.model.element.{Element, ElementKind, ExecutableElement}
import javax.lang.model.util.ElementScanner9
import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters.SeqHasAsJava

class MethodScanner extends ElementScanner9[Void, Void] {

  val methods = new ListBuffer[ExecutableElement];

  override def scan(element: Element, v: Void): Void = {
    if (element.getKind.equals(ElementKind.METHOD)) {
      methods.addOne(element.asInstanceOf[ExecutableElement]);
    }
    super.scan(element, v);
  }

  def getMethods: java.util.List[ExecutableElement] = {
    methods.asJava
  }

}
