package com.xebialabs.gradle.plugins.restdoclet.doclet

import javax.lang.model.`type`.{NoType, TypeMirror}
import javax.lang.model.element._
import scala.annotation.tailrec
import scala.jdk.CollectionConverters.CollectionHasAsScala

object JythonDocUtils {

  val excludedSuperTypes = Seq("java.lang.Object", "java.lang.Enum")

  private[doclet] def exposedMethods(c: TypeElement): Seq[ExecutableElement] = exposedMethods(Seq(c)).sortWith(_.getSimpleName.toString > _.getSimpleName.toString)

  def toTypeElementSeq(seq: Seq[TypeMirror]): Seq[TypeElement] = seq.map(DocEnv.get().getTypeUtils.asElement(_).asInstanceOf[TypeElement])

  @tailrec
  private def exposedMethods(cc: Seq[TypeElement], initial: Seq[ExecutableElement] = Seq()): Seq[ExecutableElement] = {

    val ownMethods = cc.flatten(_.getEnclosedElements.asScala
      .filter(m => m.getKind.equals(ElementKind.METHOD))
      .filter(m => m.getModifiers.contains(Modifier.PUBLIC))
      .filter(m => !m.getModifiers.contains(Modifier.STATIC)))
      .map(_.asInstanceOf[ExecutableElement])

    val ancestors = cc.flatten {
      c =>
        val superclass: Seq[TypeElement] = c.getSuperclass match {
          case tm if tm.isInstanceOf[NoType] || isExcludedType(tm) => Seq()
          case tm: TypeMirror => Seq(DocEnv.get().getTypeUtils.asElement(tm).asInstanceOf[TypeElement])
        }
        superclass ++ toTypeElementSeq(c.getInterfaces.asScala.toSeq)
    }

    val notOverridenOwn: Seq[ExecutableElement] = ownMethods.filterNot(om => initial.exists {
      i: ExecutableElement => i.toString.equals(om.toString)
    })

    ancestors match {
      case Nil => initial ++ notOverridenOwn
      case _ => exposedMethods(ancestors, initial ++ notOverridenOwn)
    }
  }

  def isExcludedType(tm: TypeMirror): Boolean = {
    val qualifiedName = DocEnv.get().getTypeUtils.asElement(tm).asInstanceOf[TypeElement].getQualifiedName.toString
    excludedSuperTypes.contains(qualifiedName)
  }
}
