/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.gradle.documentation.restdoc.doclet;

import com.google.common.base.Strings;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.SeeTree;
import com.xebialabs.commons.html.Element;
import com.xebialabs.gradle.documentation.restdoc.doclet.RestDocWriter;
import com.xebialabs.gradle.plugins.restdoclet.doclet.scanner.FirstChildrenScanner;
import com.xebialabs.gradle.plugins.restdoclet.doclet.scanner.MethodScanner;
import com.xebialabs.gradle.plugins.restdoclet.doclet.scanner.StringKindComparator;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RestServiceWriter
extends RestDocWriter {
    private static final List<String> PATH_PARAM = List.of("javax.ws.rs.PathParam", "jakarta.ws.rs.PathParam");
    private static final List<String> QUERY_PARAM = List.of("javax.ws.rs.QueryParam", "jakarta.ws.rs.QueryParam");
    private static final List<String> HEADER_PARAM = List.of("javax.ws.rs.HeaderParam", "jakarta.ws.rs.HeaderParam");
    private static final List<String> GET = List.of("javax.ws.rs.GET", "jakarta.ws.rs.GET");
    private static final List<String> POST = List.of("javax.ws.rs.POST", "jakarta.ws.rs.POST");
    private static final List<String> PUT = List.of("javax.ws.rs.PUT", "jakarta.ws.rs.PUT");
    private static final List<String> DELETE = List.of("javax.ws.rs.DELETE", "jakarta.ws.rs.DELETE");
    private static final List<String> HEAD = List.of("javax.ws.rs.HEAD", "jakarta.ws.rs.HEAD");
    private final TypeElement service;
    private final boolean printJsonContentType;
    private final String path;
    private final String defaultConsumes;
    private final String defaultProduces;

    public RestServiceWriter(PrintWriter writer, TypeElement service, boolean printJsonContentType) {
        super(writer);
        this.service = service;
        this.printJsonContentType = printJsonContentType;
        this.path = RestServiceWriter.getPath(service);
        this.defaultConsumes = this.getConsumes(service);
        this.defaultProduces = this.getProduces(service);
    }

    public void writeRestService() {
        this.writeHeader();
        this.writeIndex();
        this.writeMethodDetails();
    }

    private void writeHeader() {
        this.div(new Object[]{this.h1(new Object[]{this.service.getSimpleName().toString()})}).cssClass("manual-title").write();
        this.writeDeprecationDetails(this.service);
        this.p(new Object[]{this.asText(this.getEntireComment(this.service)) + this.parseRestDetails(this.service)}).write();
    }

    private void writeIndex() {
        this.table(new Object[0]).cssClass("parameter-table").writeOpen();
        for (ExecutableElement method : RestServiceWriter.getRestMethods(this.service)) {
            String httpMethod = RestServiceWriter.getHttpMethod(method);
            this.row(new Object[]{httpMethod, this.link("#" + this.getAnchor(method), new Object[]{this.getUri(method)}), this.asText(this.getDocTree(method))}).write();
        }
        this.table(new Object[0]).writeClose();
    }

    private void writeMethodDetails() {
        this.hr().write();
        for (ExecutableElement method : RestServiceWriter.getRestMethods(this.service)) {
            this.writeMethodDetail(method);
        }
    }

    private void writeMethodDetail(ExecutableElement method) {
        this.anchor(this.getAnchor(method), new Object[0]).write();
        this.h2(new Object[]{RestServiceWriter.getHttpMethod(method), " ", this.getUri(method)}).cssClass("resource-header").write();
        this.p(new Object[]{this.asText(this.getDeprecatedTags(method))}).write();
        String restDetails = this.parseRestDetails(method);
        this.div(new Object[]{this.asText(this.getDocTree(method)) + restDetails}).write();
        this.writePermissions(method);
        this.writeHeaders(method);
        this.writeParameters(method);
        this.writeReturnType(method);
        List<DocTree> seeDocTree = this.getSeeTags(method);
        for (DocTree seeTag : seeDocTree) {
            List<? extends DocTree> seeTreeReferenceList = ((SeeTree)seeTag).getReference();
            this.definitionList("See", new Object[]{this.asText(seeTreeReferenceList)}).write();
        }
    }

    private void writeHeaders(ExecutableElement method) {
        List<DocTree> headerTags = this.getHeadersTags(method);
        Element dt = this.definitionList("Headers", new Object[0]);
        if (!headerTags.isEmpty()) {
            for (DocTree header : headerTags) {
                String textAfterTag = this.getTextAfterTag(header, "@headers");
                String firstWord = RestServiceWriter.firstWord(textAfterTag);
                String restOfSentence = textAfterTag.substring(firstWord.length());
                dt.add(new Object[]{this.element("dd", new Object[]{this.italic(new Object[]{firstWord}), restOfSentence})});
            }
            dt.write();
        }
    }

    private void writePermissions(ExecutableElement method) {
        List<? extends DocTree> permissionDocTree = this.getPermissionTags(method);
        if (!permissionDocTree.isEmpty()) {
            Element dt = this.definitionList("Permissions", new Object[0]);
            for (DocTree docTree : permissionDocTree) {
                String firstWord;
                String textAfterTag = this.getTextAfterTag(docTree, "@permission");
                Object rest = textAfterTag.substring((firstWord = RestServiceWriter.firstWord(textAfterTag)).length());
                if (!Strings.isNullOrEmpty((String)rest)) {
                    rest = " - " + (String)rest;
                }
                dt.add(new Object[]{this.element("dd", new Object[]{this.code(new Object[]{firstWord}), rest})});
            }
            dt.write();
        }
    }

    private String getTextAfterTag(DocTree header, String tagKind) {
        FirstChildrenScanner scanner = new FirstChildrenScanner(new StringKindComparator(tagKind));
        scanner.scan(header, false);
        return scanner.getTags().get(0).toString();
    }

    private String parseRestDetails(javax.lang.model.element.Element element) {
        List<DocTree> restDetails = this.getRestDetailsTags(element);
        if (restDetails.isEmpty()) {
            return "";
        }
        return " " + this.asText(restDetails);
    }

    private void writeDeprecationDetails(javax.lang.model.element.Element element) {
        Element p = this.p(new Object[]{this.element("strong", new Object[]{"Deprecated:"})});
        List<DocTree> deprecatedTags = this.getDeprecatedTags(element);
        if (!deprecatedTags.isEmpty()) {
            p.add(new Object[]{this.italic(new Object[]{this.asText(deprecatedTags)})});
            p.write();
        }
    }

    private void writeReturnType(ExecutableElement method) {
        if ("void".equals(method.getReturnType().toString())) {
            this.definitionList("Response body", new Object[]{this.italic(new Object[]{"Empty"})}).write();
        } else {
            this.definitionList("Response body", new Object[]{this.renderType(method.getReturnType()) + this.getReturnTypeInfo(method), "Content type: " + this.getMethodProduces(method)}).write();
        }
    }

    private String getReturnTypeInfo(ExecutableElement method) {
        List<DocTree> returnTypeDocTree = this.getReturnTags(method);
        if (returnTypeDocTree.isEmpty()) {
            return "";
        }
        return " - " + this.asText(returnTypeDocTree);
    }

    private void writeParameters(ExecutableElement method) {
        List<? extends VariableElement> paramElements = method.getParameters();
        if (paramElements.isEmpty()) {
            return;
        }
        Element table = this.table(new Object[0]).cssClass("parameter-table");
        for (VariableElement variableElement : paramElements) {
            ParameterInfo info = this.getParameterInfo(method, variableElement);
            if (info == null) {
                System.out.println("Warning: No actual parameter for @param " + variableElement.getSimpleName().toString() + " on " + method);
                continue;
            }
            List<DocTree> allParamTreeList = this.getParamTags(method);
            List<Object> filteredElementForRow = new ArrayList();
            if (!allParamTreeList.isEmpty()) {
                filteredElementForRow = allParamTreeList.stream().filter(p -> p.toString().contains(paramElement.toString())).collect(Collectors.toList());
            }
            table.add(new Object[]{this.row(new Object[]{this.italic(new Object[]{info.kind}), info.name, this.renderType(info.type), this.asText(filteredElementForRow)})});
        }
        this.definitionList("Parameters", new Object[]{table}).write();
    }

    private static List<ExecutableElement> getRestMethods(TypeElement service) {
        MethodScanner scanner = new MethodScanner();
        scanner.scan((javax.lang.model.element.Element)service, null);
        return scanner.getMethods().stream().filter(RestServiceWriter::isRestMethod).sorted(new MethodComparator()).collect(Collectors.toList());
    }

    private static boolean isRestMethod(javax.lang.model.element.Element element) {
        List<? extends AnnotationMirror> mirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : mirrors) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (!annotationType.startsWith("javax.ws.rs") && !annotationType.startsWith("jakarta.ws.rs")) continue;
            return true;
        }
        return false;
    }

    private static String getPath(javax.lang.model.element.Element element) {
        String javaxAnnotation = RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Path");
        String jakartaAnnotation = RestServiceWriter.getAnnotationValue(element, "jakarta.ws.rs.Path");
        if (javaxAnnotation != null && !javaxAnnotation.isBlank()) {
            return javaxAnnotation;
        }
        return jakartaAnnotation;
    }

    private String getUri(javax.lang.model.element.Element element) {
        return this.path + "/" + RestServiceWriter.getPath(element);
    }

    private String getAnchor(javax.lang.model.element.Element element) {
        return this.getUri(element) + ":" + RestServiceWriter.getHttpMethod(element);
    }

    private String getConsumes(javax.lang.model.element.Element element) {
        String javaxValue = RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Consumes");
        String jakartaValue = RestServiceWriter.getAnnotationValue(element, "jakarta.ws.rs.Consumes");
        String annValue = javaxValue != null && !javaxValue.isBlank() ? javaxValue : jakartaValue;
        return this.optionallyStripJson(annValue.replace("\"", "").replaceAll("[\"\\]\\[]", ""));
    }

    private String optionallyStripJson(String s) {
        if (!this.printJsonContentType) {
            return s.replace("application/json", "").replaceAll(",\\s*$", "");
        }
        return s;
    }

    private String getMethodConsumes(ExecutableElement method) {
        String consumes = this.getConsumes(method);
        if (Strings.isNullOrEmpty((String)consumes)) {
            return this.defaultConsumes;
        }
        return consumes;
    }

    private String getProduces(javax.lang.model.element.Element element) {
        String javaxValue = RestServiceWriter.getAnnotationValue(element, "javax.ws.rs.Produces");
        String jakartaValue = RestServiceWriter.getAnnotationValue(element, "jakarta.ws.rs.Produces");
        String annValue = javaxValue != null && !javaxValue.isBlank() ? javaxValue : jakartaValue;
        return this.optionallyStripJson(annValue.replaceAll("[\"\\]\\[]", ""));
    }

    private String getMethodProduces(ExecutableElement method) {
        String produces = this.getProduces(method);
        if (Strings.isNullOrEmpty((String)produces)) {
            return this.defaultProduces;
        }
        return produces;
    }

    private static String getHttpMethod(javax.lang.model.element.Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (GET.contains(annotationType)) {
                return "GET";
            }
            if (POST.contains(annotationType)) {
                return "POST";
            }
            if (PUT.contains(annotationType)) {
                return "PUT";
            }
            if (DELETE.contains(annotationType)) {
                return "DELETE";
            }
            if (!HEAD.contains(annotationType)) continue;
            return "HEAD";
        }
        return "?";
    }

    public static String getAnnotationValue(javax.lang.model.element.Element element, String annotationType) {
        return RestServiceWriter.getAnnotationValue(RestServiceWriter.getAnnotation(element, annotationType));
    }

    private static String getAnnotationValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Iterator<? extends AnnotationValue> iterator = annotation.getElementValues().values().iterator();
        if (iterator.hasNext()) {
            AnnotationValue item = iterator.next();
            Object value = item.getValue();
            if (value instanceof Object[]) {
                return Arrays.asList((Object[])value).toString();
            }
            return value.toString();
        }
        return "";
    }

    private static AnnotationMirror getAnnotation(javax.lang.model.element.Element element, String type) {
        return element.getAnnotationMirrors().stream().filter(mirror -> mirror.getAnnotationType().toString().equals(type)).findFirst().orElse(null);
    }

    private ParameterInfo getParameterInfo(ExecutableElement method, VariableElement tag) {
        List<? extends VariableElement> parameters = method.getParameters();
        String name = tag.getSimpleName().toString();
        for (VariableElement variableElement : parameters) {
            if (!variableElement.getSimpleName().toString().equals(name)) continue;
            TypeMirror type = variableElement.asType();
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                String annotationType = annotationMirror.getAnnotationType().toString();
                if (PATH_PARAM.contains(annotationType)) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Path", type);
                }
                if (QUERY_PARAM.contains(annotationType)) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Query", type);
                }
                if (HEADER_PARAM.contains(annotationType)) {
                    return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Header", type);
                }
                if (!annotationType.equals("org.jboss.resteasy.annotations.providers.multipart.MultipartForm")) continue;
                return new ParameterInfo(RestServiceWriter.getAnnotationValue(annotationMirror), "Multipart", type);
            }
            return new ParameterInfo(this.getMethodConsumes(method), "Request&nbsp;body", type);
        }
        return null;
    }

    private static class ParameterInfo {
        final String name;
        final String kind;
        final TypeMirror type;

        ParameterInfo(String name, String kind, TypeMirror type) {
            this.name = name;
            this.kind = kind;
            this.type = type;
        }
    }

    private static class MethodComparator
    implements Comparator<ExecutableElement> {
        private MethodComparator() {
        }

        @Override
        public int compare(ExecutableElement method, ExecutableElement anotherMethod) {
            return RestServiceWriter.getPath(method).compareTo(RestServiceWriter.getPath(anotherMethod));
        }
    }
}

