package com.xebialabs.gradle.plugins.restdoclet.doclet.scanner;

import javax.lang.model.element.{Element, ElementKind, TypeElement}
import javax.lang.model.util.ElementScanner9
import scala.collection.mutable

class ClassScanner extends ElementScanner9[Void, Void] {

    private val desiredKinds = mutable.Set(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE)
    val classes: mutable.Set[TypeElement] = mutable.Set[TypeElement]()

    override def scan(e: Element, unused: Void): Void = {
        if (desiredKinds.contains(e.getKind)) {
            classes.addOne(e.asInstanceOf[TypeElement]);
        }

        super.scan(e, unused);
    }

}
