package com.xebialabs.gradle.plugins.restdoclet.doclet

import com.sun.source.doctree._

import javax.lang.model.element.{Element, TypeElement}


object DocTreeUtils {

  def textFromTags(e: Element, trees: List[DocTree]): String = {
    trees.foldLeft("")(
      (s, t) => s + (t match {
        case doc: SeeTree => doc.getReference.toString
        case doc: TextTree => doc.getBody
        case doc: LinkTree if doc.getReference.getSignature.startsWith("#") && e.getEnclosingElement.isInstanceOf[TypeElement] =>
           s"{@${doc.getKind.tagName} ${e.getEnclosingElement.asInstanceOf[TypeElement].getQualifiedName.toString}${doc.getReference}}"
        case doc: LinkTree if !doc.getReference.getSignature.startsWith("#") =>
          s"{@${doc.getTagName} ${doc.getReference.getSignature}}"
        case _: ReferenceTree => ""
        case tag => tag.toString
      })
    )
  }

}
