package com.xebialabs.gradle.documentation.restdoc.doclet;

import java.util.List;
import java.util.function.Consumer;

import jdk.javadoc.doclet.Doclet;

public class StandardOption implements Doclet.Option {

    private final String name;
    private final Consumer<String> setter;
    private final Integer argumentCount;

    public StandardOption(String name, Consumer<String> setter) {
        this.name = name;
        this.setter = setter;
        this.argumentCount = 1;
    }

    @Override
    public int getArgumentCount() {
        return argumentCount;
    }

    @Override
    public String getDescription() {
        return name;
    }

    @Override
    public Kind getKind() {
        return Kind.STANDARD;
    }

    @Override
    public List<String> getNames() {
        return List.of(name);
    }

    @Override
    public String getParameters() {
        return name;
    }

    @Override
    public boolean process(String option, List<String> arguments) {
        if (!arguments.isEmpty()) {
            setter.accept(arguments.get(0));
        }
        return true;
    }
}
