package com.xebialabs.gradle.documentation.restdoc

import com.xebialabs.gradle.documentation.restdoc.tasks.CheckJsonJavaDocTask
import org.gradle.api.GradleException
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.tasks.javadoc.Javadoc

class CheckJsonJavaDocPlugin implements Plugin<Project> {

  @Override
  void apply(final Project project) {
    if (project.rootProject != project) {
      throw new GradleException("${project} is not a root project. Cannot apply check-json-javadocs need all generated json files to check consistency.")
    }

    def checkTask = project.tasks.create("checkMissingLinks", CheckJsonJavaDocTask)

    project.allprojects*.afterEvaluate { Project p ->
      Javadoc restdocTask = p.tasks.findByName(RestdocletPlugin.RESTDOC_TASK_NAME)
      if (restdocTask != null) {
        checkTask.dependsOn restdocTask
        def jsonFile = new File(restdocTask.destinationDir, "${-> p.name}.json")
        checkTask.inputFiles.add(jsonFile)
      }
    }
  }
}
